/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//	.NAME AlAngleLocator - Displays the included angle between three locators.
//
//	.SECTION Description
//		An angle locator is used to find the included angle between any three point
//		locators (AlPointLocator). If any of the three point locators on which
//		this locator depends is deleted, this locator is automatically deleted.
//		This class contains methods to create the locator, query the
//		distance, and set the display attributes of the locator in the Alias
//		windows.
#ifndef __AlAngleLocator
#define __AlAngleLocator

#include <AlLocator.h>
class AlPoint;

class STUDIOAPI_DECL AlAngleLocator : public AlLocator{
	friend class			AlFriend;

public:
	AlAngleLocator();
	~AlAngleLocator();
	
	virtual AlObject *		copyWrapper() const;
	virtual AlObjectType	type() const;
	statusCode		   		create(const AlPoint *,
								   const AlPoint *,
								   const AlPoint *,
								   API_BOOLEAN trueDisplay = TRUE);
								   
	AlPoint*       			startPoint() const;
	AlPoint*       			middlePoint() const;
	AlPoint*       			endPoint() const;
	
	statusCode             	trueDisplay(API_BOOLEAN &) const;
	statusCode             	setTrueDisplay(API_BOOLEAN);
	
	statusCode             	offset(double &) const;
	
	statusCode             	setOffset(double);

	statusCode             	angle(double &) const;

    double                  worldSpaceOffset(double &) const;
    statusCode              setWorldSpaceOffset(double);
};


#endif

