/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlAmbientLight - Encapsulates the creation, deletion and manipulation of an ambient light.
//
//	.SECTION Description
//
//		An ambient light is similar to a point light, except that only
//		a portion of the illumination comes from the point.  The
//		remainder of the illumination comes from all directions and
//		lights everything uniformly.
//
//		(For more information on lights in general, see the
//		Class Description of the AlLight class.)
//


#ifndef _AlAmbientLight
#define _AlAmbientLight

#include <AlLight.h>

class STUDIOAPI_DECL AlAmbientLight : public AlLight {

public:
						AlAmbientLight();
	virtual				~AlAmbientLight();

	virtual AlObject*	copyWrapper() const;

	statusCode			create();

	AlObjectType		type() const;

	double				shadeFactor() const;
	double				intensity() const;

	statusCode			setShadeFactor( double );
	statusCode			setIntensity( double );

private:
	// init/fini messages inherited
};
#endif
