/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlAction - Basic interface to Alias actions
//
//	.SECTION Description
//		AlAction is the base class for an Alias action.  An action
//	is an entity that will map time to a value.  In Alias, there are
//	two types of actions: parameter curve actions, represented by the
//	derived class AlParamAction, and motion path actions, represented by
//	the derived class AlMotionAction.
//
//		You can create new AlActions by creating an AlParamAction or an
//	AlMotionAction.  Existing actions can be accessed either through the
//	global list of actions (AlUniverse::firstAction(), AlUniverse::nextAction())
//	or through the list of actions which a channel uses to animate a field
//	of an item (AlChannel::appliedAction()).  Note that if you delete an
//	action, it may cause other classes to be deleted (for example, AlKeyframe,
//	and AlChannel if the action was the base action of a channel).
//

#ifndef _AlAction
#define _AlAction

#include <AlObject.h>
#include <AlAnim.h>

extern "C" {
	struct Aa_Action;
}

class STUDIOAPI_DECL AlAction : public AlObject
{
	friend					class AlFriend;
public:
	virtual					~AlAction();
	virtual statusCode		deleteObject();

	virtual AlObjectType	type() const;
	virtual const char*		name() const;
	virtual statusCode		setName(const char *);

	const char*				comment() const;
	AlActionExtrapType		extrapTypePRE() const;
	AlActionExtrapType		extrapTypePOST() const;

	statusCode				setComment(const char *);
	statusCode				setExtrapTypePRE(AlActionExtrapType);
	statusCode				setExtrapTypePOST(AlActionExtrapType);

	AlAction*				copy() const;
	statusCode				copyD();

	double					eval( double, AlTripleComponent = kX_COMPONENT ) const;

	int						numChannelReferences() const;
	AlChannel*				channelReference(const int) const;

protected:
							AlAction();

	virtual AlAction* 		constructAction( Aa_Action* ) const = 0;
private:

	static void				initMessages();
	static void				finiMessages();
};

#endif	// _AlAction
