/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

#ifndef _AlAccessTypes
#define _AlAccessTypes

typedef enum {
	kAmbientLightType,
	kAreaLightType,
	kBoxLightType,
	kCameraEyeType,
	kCameraType,
	kCameraUpType,
	kCameraViewType,
	kClusterNodeType,
	kClusterType,
	kClusterMemberType,
	kConeLightType,
	kCurveNodeType,
	kCurveOnSurfaceType,
	kCurveType,
	kCurveCVType,
	kCylinderLightType,
	kDagNodeType,
	kDirectionLightType,
	kFaceNodeType,
	kFaceType,
	kGroupNodeType,
	kImagePlaneType,
	kLightLookAtNodeType,
	kLightNodeType,
	kLightType,
	kLightUpNodeType,
	kLinearLightType,
	kNonAmbientLightType,
	kOrthographicCameraType,
	kPerspectiveCameraType,
	kPointLightType,
	kSetType,
	kSetMemberType,
	kSphereLightType,
	kSpotLightType,
	kSurfaceNodeType,
	kSurfaceType,
    kSurfaceCurveType,
	kSurfaceCVType,
	kTorusLightType,
	kVolumeLightType,
	kWindowType,

	kChannelType,
	kActionType,
	kParamActionType,
	kMotionActionType,
	kKeyframeType,
	kStreamType,

	kEnvironmentType,
	kShaderType,
	kTextureType,

	kPolysetNodeType,
	kPolysetType,
	kPolygonType,
	kPolysetVertexType,

	kAttributeType,
	kArcAttributeType,
	kLineAttributeType,
	kCurveAttributeType,
	kPlaneAttributeType,
	kConicAttributeType,
	kRevSurfAttributeType,

	kJointType,
	kConstraintType,
	kPointConstraintType,
	kOrientationConstraintType,
	kAimConstraintType,

	kTextureNodeType,

	kShellNodeType,
	kShellType,

	kTrimRegionType,
	kTrimBoundaryType,
	kTrimCurveType,

	kCommandType,
	kCommandRefType,
	kContactType,

	kCharacterSpaceType,
	kCharacterType,
	kCharSnippetType,
	kCharTransitionType,

	kIKHandleType,
	kIKHandleNodeType,

	kLocatorType,
	kAnnotationLocatorType,
	kDistanceLocatorType,
	kAngleLocatorType,
	kRadialLocatorType,
	kDeviationLocatorType,
	kMinmaxLocatorType,

	kConstructionEntityType,
	kConstructionVectorType,
	kConstructionPlaneType,
	kConstructionFutureType1,	// For future additions, do not use.
	kConstructionFutureType2,	// For future additions, do not use.
	kPointType,
	kSpacePointType,
	kCurvePointType,
	kSurfacePointType,
	kCurveOnSurfacePointType,
	kFuturePointType1,			// For future additions, do not use.
	kFuturePointType2,			// For future additions, do not use.
	kFuturePointType3,			// For future additions, do not use.
	kFuturePointType4,			// For future additions, do not use.
	kFuturePointType5,			// For future additions, do not use.
	
	kLayerType,

	kCloudType,

	kBlendCurveType,
	kBlendPointType,

    kCategoryType,

    kMeshType,
    kMeshNodeType,

    kEvaluateType,

    kReferenceFileType,
    kReferenceFileSetType,

    kSwitchShaderType,

    kReferenceObjectType,
    kReferenceLayerType,

    kLayeredShaderType

} AlObjectType;

typedef enum {
	kSurfaceCurveU    = 0,
	kSurfaceCurveV   	= 1,
} AlSurfaceCurveType;

typedef enum {
	kLightGlowOff			= 0,
	kLightGlowLinear		= 1,
	kLightGlowExponential	= 2,
	kLightGlowBall			= 3,
	kLightGlowSpectral		= 4,
	kLightGlowRainbow		= 5
} AlLightGlowType;

typedef enum {
	kLightHaloOff			= 0,
	kLightHaloLinear		= 1,
	kLightHaloExponential	= 2,
	kLightHaloBall			= 3,
	kLightHaloLensFlare		= 4,
	kLightHaloRimHalo		= 5
} AlLightHaloType;

typedef enum {
	kLightFogOff			= 0,
	kLightFogLinear			= 1,
	kLightFogExponential	= 2,
	kLightFogBall			= 3
} AlLightFogType;

typedef enum {
	kDisplayModeBoundingBox,	/* These first five can only be used */
	kDisplayModeInvisible,		/* by AlDagNode::isDisplayModeSet() */
	kDisplayModeTemplate,
	kDisplayModeDashed,

	kDisplayGeomHull,			/* These four can only be used by the */
	kDisplayGeomEditPoints,		/* AlCurve, AlSurface and AlPolyset */
	kDisplayGeomKeyPoints,		/* isDisplayModeSet() and setDisplayMode() */
	kDisplayGeomCVs,			/* methods. */

	kDisplayModeConstructionPlane,/* These two can only be used by    */
	kDisplayModeCompressedSbd    /* AlDagNode::isDisplayModeSet()    */
								  /* and AlDagNode::setDisplayMode(). */

} AlDisplayModeType;

#endif



