/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

#include	<AlAccessTypes.h>
#include	<AlShadingFields.h>
#include	<AlModel.h>
#include	<AlObject.h>
#include	<AlDebug.h>

extern "C" {

const char* determineFieldName( AlShadingFields fieldLabel );
const char* determineObjectClassName( AlObjectType type );
const char* determineFormTypeName( curveFormType form );

#define Xconst 	/*const*/

void printFile( const char *fmt, ... );
void setPrintFile( AlOutputType ot );

int  getIndentation( void );
char *indentSpace( void );
void setIndentation( int );

void printObjectName(			const AlObject * );

void printAlAction(				Xconst AlAction *action);
void printAlAmbientLight(		Xconst AlAmbientLight *light, AlTM& );
void printAlAreaLight(			Xconst AlAreaLight *light, AlTM& );
void printAlCamera(				Xconst AlCamera *camera, AlTM& );
void printAlCameraNode( 		Xconst AlCameraNode *cameraNode, AlTM& );
void printAlChannel(			Xconst AlChannel *channel);
void printAlCloud(				Xconst AlCloud *cloud );
void printAlCluster(			Xconst AlCluster *cluster, AlTM& );
void printAlClusterNode(		Xconst AlClusterNode *clusterNode, AlTM& );
void printAlCurve(				Xconst AlCurve *curve, AlTM& );
void printAlCurveCV(			Xconst AlCurveCV *curveCV, AlTM& );
void printAlCurveNode(			Xconst AlCurveNode *curveNode, AlTM& );
void printAlCurveOnSurface(		Xconst AlCurveOnSurface *cos, AlTM& );
void printAlCurvesOnSurface(	Xconst AlSurface *surface, AlTM& );
void printAlDagNode(			Xconst AlDagNode *dagNode, AlTM& );
void printAlDirectionLight(		Xconst AlDirectionLight *light, AlTM& );
void printAlEnvironment(		Xconst AlEnvironment *env, AlTM& );
void printAlFace(				Xconst AlFace *face, AlTM& );
void printAlFaceNode(			Xconst AlFaceNode *faceNode, AlTM& );
void printAlGroupNode(			Xconst AlGroupNode *groupNode, AlTM& );
void printAlConstraint(			Xconst AlConstraint *constraint);
void printAlJoint(				Xconst AlJoint *joint, AlTM& );
void printAlIKHandle(			Xconst AlIKHandle *ikHandle, AlTM& );
void printAlKeyframe(			Xconst AlKeyframe *keyframe);
void printAlLightNode(			Xconst AlLightNode *lightNode, AlTM& );
void printAlLinearLight(		Xconst AlLinearLight *light, AlTM& );
void printAlMotionAction(		Xconst AlMotionAction *action );
void printAlObject(				Xconst AlObject *object );
void printAlParamAction(		Xconst AlParamAction *action);
void printAlPointLight(			Xconst AlPointLight *light, AlTM& );
void printAlPolysetNode(		Xconst AlPolysetNode *polysetNode, AlTM& );
void printAlMeshNode(		    Xconst AlMeshNode *meshNode, AlTM& );
void printAlSet(				Xconst AlSet *set );
void printAlShader(				Xconst AlShader *shader, AlTM& );
void printAlSpotLight(			Xconst AlSpotLight *light, AlTM& );
void printAlSurface(			Xconst AlSurface *surface, AlTM& );
void printAlSurfaceCV(			Xconst AlSurfaceCV *surfaceCV, AlTM&);
void printAlSurfaceNode(		Xconst AlSurfaceNode *surfaceNode, AlTM& );
void printAlSurfaceTrimRegions(	Xconst AlSurface *surface, AlTM& );
void printAlShell(				Xconst AlShell *shell, AlTM&);
void printAlShellNode(			Xconst AlShellNode* shellNode, AlTM& );
void printAlTexture(			Xconst AlTexture *texture, AlTM&);
void printAlTextureNode(		Xconst AlTextureNode* textureNode, AlTM& );
void printAlTrimBoundary(		Xconst AlTrimBoundary *boundary, AlTM& );
void printAlTrimCurve(			Xconst AlTrimCurve *curve, AlTM& );
void printAlTrimRegion(			Xconst AlTrimRegion *region, AlTM& );
void printAlBlendCurve(			Xconst AlBlendCurve *blendCurve );
void printAlBlendPoint(			Xconst AlBlendPoint *blendPoint );
void printAlLocator( 			Xconst AlLocator *locator );
void printAlConstructionEntity( Xconst AlConstructionEntity *ce );
void printAlLayer( 				Xconst AlLayer *ly );

void printAllActions( void );
void printAllAlObjects( 		Xconst AlObject *object, AlTM );
void printAllChannels( void );
void printAllSets( void );
void printAllShading( void );
void printAl_All(				AlOutputType );
void printAl_AllToFile(			Xconst char *,  Xconst char * = NULL );

void printAttributes(			Xconst AlAttributes* attributes );

}

