
use AutoTest;
use IO::Handle;
use DirHandle;
use Net::SMTP;

local $TotalTests = 0;
local $TotalFailures = 0;
local $TestDay;

sub createHTMLPages 
{
	$htmlDirPath = AutoTest::getAutoTestHTMLDirectory;
	$htmlDataDirPath = "$htmlDirPath" . "data\\\\";
	## Open the current stats file and retrieve the test counter
	$statsFilePath = "$htmlDataDirPath" . "statsFile.stat";
	open(statsIn, "$statsFilePath") or die "Can not open Stats File: $statsFilePath\n";
	$testIdCounter = <statsIn>;
	close statsIn;
	
	## Create index.html page
	$indexPage = "$htmlDirPath" . "index.html";
	createHTMLheader ($indexPage);
	createHTMLIndexTableHeader ($indexPage);
	
	## Start creating HTML pages for each day of tests
	opendir htmlDataDir, $htmlDataDirPath;
	@allfiles = grep /\.data/, readdir htmlDataDir;
	close htmlDataDir;
	
	foreach $file (@allfiles)
	{
		$TotalTests = 0;
		$TotalFailures = 0;
		$currentDataFile = "$htmlDataDirPath" . "$file";
		@fileNameParts = split /\./, $file;
		$currentHTMLFile = "$htmlDirPath" . "$fileNameParts[0]" . "\.html";
		createHTMLheader ($currentHTMLFile);
		open(fileIn, "$currentDataFile") or die "Can not open read only file: $currentDataFile\n";
		@alllines = <fileIn>;
		createHTMLReportTableHeader($currentHTMLFile);
		foreach $line (@alllines)
		{
			$TotalTests += 1;
			addHTMLReportTableEntry($currentHTMLFile, $line, $currentDataFile);
		}
		createHTMLReportTableFooter($currentHTMLFile);
		createHTMLfooter ($currentHTMLFile);
		addHTMLIndexTableEntry ($indexPage, $currentHTMLFile);
	}
	
	#End the index.html file
	createHTMLIndexTableFooter ($indexPage);
	createHTMLfooter ($indexPage);
}

sub buildHTMLFromDirectory
{
	my ( $htmlDirPath ) = @_;
	$htmlDataDirPath = "$htmlDirPath" . "data\\\\";
	## Open the current stats file and retrieve the test counter
	$statsFilePath = "$htmlDataDirPath" . "statsFile.stat";
	open(statsIn, "$statsFilePath") or die "Can not open Stats File: $statsFilePath\n";
	$testIdCounter = <statsIn>;
	close statsIn;
	
	## Create index.html page
	$indexPage = "$htmlDirPath" . "index.html";
	createHTMLheader ($indexPage);
	createHTMLIndexTableHeader ($indexPage);
	
	## Start creating HTML pages for each day of tests
	opendir htmlDataDir, $htmlDataDirPath;
	@allfiles = grep /\.data/, readdir htmlDataDir;
	close htmlDataDir;
	
	foreach $file (@allfiles)
	{
		$TotalTests = 0;
		$TotalFailures = 0;
		$currentDataFile = "$htmlDataDirPath" . "$file";
		@fileNameParts = split /\./, $file;
		$currentHTMLFile = "$htmlDirPath" . "$fileNameParts[0]" . "\.html";
		createHTMLheader ($currentHTMLFile);
		open(fileIn, "$currentDataFile") or die "Can not open read only file: $currentDataFile\n";
		@alllines = <fileIn>;
		createHTMLReportTableHeader($currentHTMLFile);
		foreach $line (@alllines)
		{
			$TotalTests += 1;
			addHTMLReportTableEntry($currentHTMLFile, $line, $currentDataFile);
		}
		createHTMLReportTableFooter($currentHTMLFile);
		createHTMLfooter ($currentHTMLFile);
		addHTMLIndexTableEntry ($indexPage, $currentHTMLFile);
	}
	
	#End the index.html file
	createHTMLIndexTableFooter ($indexPage);
	createHTMLfooter ($indexPage);
}

sub createHTMLheader 
{
	my ( $filename ) = @_;
	open(fileOut1, "> $filename") or die "Can not Create File: $filename\n";
	print fileOut1 "<HTML>\n<HEAD>\n<TITLE>\nAutoTest Generated HTML Report\n</TITLE>\n";
	print fileOut1 "<style type=\"text/css\">\n";
	print fileOut1 "<\!--\n";
	print fileOut1 "body        {font-family:serif\;}\n";
	print fileOut1 "a           {text-decoration:none\;color:\#00f\;}\n";
	print fileOut1 "a:visited   {text-decoration:none\;color:840084\;}\n";
	print fileOut1 "td          {font-family:serif, monospace;font-size:smaller\;text-align:center\;}\n";
	print fileOut1 "th.footer   {font-family:serif\;font-size:100\%\;text-align:left\;font-weight:normal\;}\n";
	print fileOut1 "td.footer   {font-family:serif\;font-size:100\%\;text-align:left\;}\n";
	print fileOut1 "td.fail     {font-family:serif, monospace\;font-size:smaller\;font-style:bold\; background-color:\#ee4444\;}\n";
	print fileOut1 "td.pass     {font-family:serif, monospace\;font-size:smaller\;font-style:normal\; background-color:\#66ee66\;}\n";
	print fileOut1 "td.warnings {font-family:serif, monospace\;font-size:smaller\;font-style:normal\; background-color:\#ffff00\;}\n";
	print fileOut1 "td.testfail {font-family:serif, monospace\;font-size:smaller\;font-style:normal\; background-color:\#ffcc00\;}\n";
	print fileOut1 "td.normal   {font-family:serif, monospace\;font-size:smaller\;font-style:normal\; background-color:\#e9fff3\;}\n";
	print fileOut1 "td.header   {font-family:serif, monospace\;font-size:smaller\;font-style:normal\; background-color:\#ffffcc\;}\n";

	print fileOut1 "input.link {color: \#00f\; background-color: transparent\;\n";
    print fileOut1 "text-decoration: none\; border: none\;\n";
    print fileOut1 "cursor: pointer\; cursor: hand\;}\n";
	print fileOut1 "-->\n";
	print fileOut1 "</style>\n";
	print fileOut1 "</HEAD>\n<BODY bgcolor=\"\#eeeeee\">\n";
	print fileOut1 "<hr>\n";
    print fileOut1 "<b><center>AutoTest Page Generated : ";
    print fileOut1 scalar localtime;
    print fileOut1 "</center></b>\n";
    print fileOut1 "<hr>\n";
	close fileOut1;
}

sub createHTMLfooter 
{
	my ( $filename ) = @_;
	open(fileOut2, ">> $filename") or die "Can not Append To File: $filename\n";
	print fileOut2 "</BODY>\n</HTML>\n";
	close fileOut2;
}

sub createHTMLReportTableHeader
{
	my ( $filename ) = @_;
	open(fileOut3, ">> $filename") or die "Can not Append To File: $filename\n";
	print fileOut3 "<CENTER>\n";
	print fileOut3 "<TABLE BORDER=1 CELLPADDING=10 CELLSPACING=0 WIDTH=100%>\n";
	print fileOut3 "<TR>\n";
	print fileOut3 "<TD class=\"header\">Test ID</TD>\n";
	print fileOut3 "<TD class=\"header\">Test Name</TD>\n";
	print fileOut3 "<TD class=\"header\">Start Time</TD>\n";
	print fileOut3 "<TD class=\"header\">End Time</TD>\n";
	print fileOut3 "<TD class=\"header\">Regression Test</TD>\n";
	print fileOut3 "<TD class=\"header\">Created Universe</TD>\n";
	print fileOut3 "<TD class=\"header\">Branch Compare</TD>\n";
	print fileOut3 "<TD class=\"header\">DAG Transform Compare</TD>\n";
	print fileOut3 "<TD class=\"header\">AG Object Compare</TD>\n";
	print fileOut3 "<TD class=\"header\">Test Passed/Failed</TD>\n";
	print fileOut3 "<TD class=\"header\">Failure Details</TD>\n";
	print fileOut3 "</TR>\n";
	close fileOut3;
}

sub createHTMLReportTableFooter
{
	my ( $filename ) = @_;
	open(fileOut4, ">> $filename") or die "Can not Append To File: $filename\n";
	print fileOut4 "</TABLE>";
	print fileOut4 "</CENTER>\n";
	print fileOut4 "<BR><BR>\n";
	print fileOut4 "<a href=\"index.html\"> AutoTest Main Index </a>";
	close fileOut4;
}

sub createHTMLFailureTableHeader
{
	my ( $filename ) = @_;
	open(fileOut5, ">> $filename") or die "Can not Append To File: $filename\n";
	print fileOut5 "<CENTER>\n";
	print fileOut5 "<TABLE BORDER=1 CELLPADDING=10 CELLSPACING=0 WIDTH=75%>\n";
	print fileOut5 "<TR>\n";
	print fileOut5 "<TD class=\"header\">Test ID</TD>\n";
	print fileOut5 "<TD class=\"header\">Test Name</TD>\n";
	print fileOut5 "<TD class=\"header\">Error Occured</TD>\n";
	print fileOut5 "<TD class=\"header\">Severity</TD>\n";
	print fileOut5 "<TD class=\"header\">Failure Details</TD>\n";
	print fileOut5 "</TR>\n";
	close fileOut5;
}

sub createHTMLFailureTableFooter
{
	my ( $filename ) = @_;
	open(fileOut6, ">> $filename") or die "Can not Append To File: $filename\n";
	print fileOut6 "</TABLE>";
	print fileOut6 "</CENTER>\n";
	print fileOut6 "<BR><BR>\n";
	print fileOut6 "<a href=\"index.html\"> AutoTest Main Index </a>";
	close fileOut6;
}

sub addHTMLReportTableEntry
{
	my ( $filename, $line, $DataFile ) = @_;
	open(fileOut7, ">> $filename") or die "Can not Append To File: $filename\n";
	my (@tableEntries) = split /\|/, $line;
	print fileOut7 "<TR>\n";
	print fileOut7 "<TD class=\"normal\">$tableEntries[0]</TD>\n";
	print fileOut7 "<TD class=\"normal\">$tableEntries[1]</TD>\n";
	print fileOut7 "<TD class=\"normal\">$tableEntries[2]</TD>\n";
	print fileOut7 "<TD class=\"normal\">$tableEntries[3]</TD>\n";

	for ($i = 4; $i < 9; $i++) {	
		if ($tableEntries[$i] == 0) {
			print fileOut7 "<TD class=\"fail\"> Failed </TD>\n";
		}
		else {
			print fileOut7 "<TD class=\"pass\"> Passed </TD>\n";
		}
	}
	if (scalar($tableEntries[9]) != 0) {
			print fileOut7 "<TD class=\"fail\"> Failed </TD>\n";
			$TotalFailures += 1;
			@dataFileParts = split /\./, $DataFile;
			@htmlFileParts = split /\./, $filename;
			$newHTMLFile = "$htmlFileParts[0]" . "_$tableEntries[0]" . "\.html";
			$newDataFile = "$dataFileParts[0]" . "_$tableEntries[0]" . "\.fail";
			createFailuresPage($newHTMLFile, $newDataFile, $tableEntries[0], $tableEntries[1]);
			my (@relativeParts) = split /\\/, $htmlFileParts[0];
			my ($relativeName) = "$relativeParts[$#relativeParts]" . "_$tableEntries[0]" . "\.html";
			print fileOut7 "<TD class=\"fail\">";
			print fileOut7 "<a href=\"$relativeName\"> Error List </a>";
			print fileOut7 "</TD>\n";
			
		}
		else {
			print fileOut7 "<TD class=\"pass\"> Passed </TD>\n";
			print fileOut7 "<TD class=\"normal\">$tableEntries[9]</TD>\n";
		}
	
	print fileOut7 "</TR>\n";
	close fileOut7;
	$TestDay = "$tableEntries[2]";   #this gets assigned many times but thats ok
}

sub addHTMLFailureTableEntry
{
	my ( $filename, $line, $testid, $testname ) = @_;
	open(fileOut8, ">> $filename") or die "Can not Append To File: $filename\n";
	@failuresEntries = split /\|/, $line;
	print fileOut8 "<TR>\n";
	print fileOut8 "<TD class=\"normal\">$testid</TD>\n";
	print fileOut8 "<TD class=\"normal\">$testname</TD>\n";
	print fileOut8 "<TD class=\"normal\">$failuresEntries[0]</TD>\n";
	print fileOut8 "<TD class=\"normal\">$failuresEntries[1]</TD>\n";
	print fileOut8 "<TD class=\"normal\">$failuresEntries[2]</TD>\n";

	print fileOut8 "</TR>\n";
	close fileOut8;
}

sub createFailuresPage
{
	my ( $currentHTMLFile, $currentDataFile, $testid, $testname ) = @_;
	
	createHTMLheader ($currentHTMLFile);
	open(fileIn, "$currentDataFile") or die "Can not open read only file: $currentDataFile\n";
	@allFailureLines = <fileIn>;
	createHTMLFailureTableHeader($currentHTMLFile);
		foreach $failureLine (@allFailureLines)
		{
			addHTMLFailureTableEntry($currentHTMLFile, $failureLine, $testid, $testname);
		}
	createHTMLFailureTableFooter($currentHTMLFile);
	createHTMLfooter ($currentHTMLFile);
}

sub createHTMLIndexTableHeader
{
	my ( $filename ) = @_;
	open(fileOut9, ">> $filename") or die "Can not Append To File: $filename\n";
	print fileOut9 "<CENTER>\n";
	print fileOut9 "<TABLE BORDER=1 CELLPADDING=10 CELLSPACING=0 WIDTH=50%>\n";
	print fileOut9 "<TR>\n";
	print fileOut9 "<TD class=\"header\"> Tests Run on Date </TD>\n";
	print fileOut9 "<TD class=\"header\"> Number of Tests Run </TD>\n";
	print fileOut9 "<TD class=\"header\"> Number of Failures </TD>\n";
	print fileOut9 "</TR>\n";
	close fileOut9;
}

sub createHTMLIndexTableFooter
{
	my ( $filename ) = @_;
	open(fileOut10, ">> $filename") or die "Can not Append To File: $filename\n";
	print fileOut10 "</TABLE>\n";
	print fileOut10 "</CENTER>\n";
	close fileOut10;
}

sub addHTMLIndexTableEntry
{
	my ( $filename, $linkpath ) = @_;
	open(fileOut11, ">> $filename") or die "Can not Append To File: $filename\n";
	@date = split / /, $TestDay;
	$linkName = "$date[0]" . " $date[1]" . " $date[2]" . " $date[3]";
	my (@relativeParts) = split /\\/, $linkpath;
	my ($relativeName) = $relativeParts[$#relativeParts];
	print fileOut11 "<TR>\n";
	print fileOut11 "<TD class=\"normal\">";
	print fileOut11 "<a href=\"$relativeName\"> $linkName </a>";
	print fileOut11 "</TD>\n";
	print fileOut11 "<TD class=\"normal\"> $TotalTests </TD>\n";
	if ($TotalFailures > 0) {
		print fileOut11 "<TD class=\"fail\"> $TotalFailures </TD>\n";
	} else {
		print fileOut11 "<TD class=\"normal\"> $TotalFailures </TD>\n";
	}
	print fileOut11 "</TR>\n";
	close fileOut11;
}

sub sendReportEmail
{
	my ($recipients) = @_;
	if (!$recipients)
	{
		return;
	}
	#Create a grep search string containing todays date
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$year += 1900;
	$mon += 1;
	$mon = sprintf("%02d", $mon);
	$mday = sprintf("%02d", $mday);
	$search = $year . "-" . $mon . "-" . $mday;

	#Open the html/data directory and search for a file with todays date
	$htmlDirPath = AutoTest::getAutoTestHTMLDirectory;
	$htmlDataDirPath = "$htmlDirPath" . "data\\";
	opendir htmlDataDir, $htmlDataDirPath;
	@todaystestfiles = grep /$search/, readdir htmlDataDir;
	close htmlDataDir;

	if ($#todaystestfiles < 0)
	{
		$content = $mday . "-" . $mon . "-" . $year . " - Today's tests failed to run.  Please check the AutoTest Machine.\n";
	}
	else 
	{
		$search = $mday . "-" . $mon . "-" . $year . "\.\*fail";
		opendir htmlDataDir, $htmlDataDirPath;
		@todayserrorfiles = grep /$search/, readdir htmlDataDir;
		close htmlDataDir;
		if ($#todayserrorfiles >= 0)
		{
			$content = mday . "-" . $mon . "-" . $year . " Failures occurred during the nightly test run.  Please check \\\\pc-qa-dellp330\\AutoTestHTML\\index.html for details.\n";
		}
		else
		{
			$content = $mday . "-" . $mon . "-" . $year . " Automated Testing completed with no failures.";
		}
	}
	
	
	$smtp = Net::SMTP->new('cerveza.tor.aw.sgi.com'); # connect to an SMTP server
	$smtp->mail( 'StudioAutoTest' );	    # use the sender's address here
	$smtp->to("$recipients");				# recipient's address
	$smtp->data();							# Start the mail

	## Send the header.
	$smtp->datasend("To: $recipients\n");
	$smtp->datasend("From: StudioAutoTest\n");
	$smtp->datasend("\n");

	## Send the body.
	$smtp->datasend("$content\n");
	$smtp->dataend();                   # Finish sending the mail
	$smtp->quit;                        # Close the SMTP connection
}

# for auto-load
return 1;
