#%
# \page _studio_::StudioScripting Studio Scripting
#

#%
# \page _studio_::StudioScripting::autoTestRun Wrapper script
#
# \p This script configures environment variables required by the
# studio scripter, executes the required Perl modules, initializes the
# connectino to Studio and runs the test script specified on the
# command line.

if( $#ARGV != 2 )
{
    die "Incorrect usage.";
}

my $scriptDir = $ARGV[0];
my $port = $ARGV[1];
my $script = $ARGV[2];

unshift( @INC, $scriptDir );
unshift( @INC, "d:/testomatic/dist/studioacceptance/testsuite" );
require "$scriptDir/basisOperations.pl";

AutoTestImpl::initialize( $port );

debugPrint( "Starting script $script\n" );

do $script;
if( length($@) > 0 )
{
    debugPrint( "Script $script failed:\n  $@" );
}
else
{
    debugPrint( "Script $script finished\n" );
}

exit 0;
