####################################################################
# (C) Copyright 2007 by Autodesk, Inc. All Rights Reserved. By using
# this code,  you  are  agreeing  to the terms and conditions of the
# License  Agreement  included  in  the documentation for this code.
# AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
# CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
# IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
# DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
# DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
#
# Use, duplication,  or disclosure by the U.S. Government is subject
# to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
# Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
# (Rights  in Technical Data and Computer Software),  as applicable.
####################################################################

package AutoTestImpl;

our( @EXPORT );

use strict;
use Socket;

@EXPORT = qw(
    initialize
    finalize
    call
);

my $socket;


sub initialize
{
    my $port = shift;
    my $host = 'localhost';

    my $proto = getprotobyname('tcp');

    # get the port address
    my $iaddr = inet_aton($host);
    my $paddr = sockaddr_in($port, $iaddr);

    # create the socket, connect to the port
    socket(SOCKET, PF_INET, SOCK_STREAM, $proto) || die "socket: $!";
    connect(SOCKET, $paddr) || die "connect: $!";

    $socket = \*SOCKET;
}


sub finalize
{
    close( $socket ) or die "close: $!";
}


sub call
{
    my @args = @_;

    # collect together the function and arguments
    my $msg;
    while( $#args >= 0 )
    {
        my $code = shift( @args );
        my $arg = shift( @args );
        
        my $str = sprintf( "%02d%06d", $code, length($arg) );
        $msg = $msg . $str . $arg;
    }

    $msg = sprintf( "%06d%s", length($msg), $msg );
    send( $socket, $msg, 0 );

    # read the length of the result
    my $length;
    recv( $socket, $length, 6, 0 );

    # read the result
    my $result;
    recv( $socket, $result, $length, 0 );

    # return the result, skipping the type code
    # Michael Wei: return 011 if pass or 010 if fail from socket server,
    # so change code from substr( $result, 0, 2 ) to substr( $result, -1, 1 ) 
    # to get the last number as return status, not the first two number.
    $result = substr( $result, -1, 1 );
    return $result;
}

1;
