
 
function onLoaded() {
    
    
    window.projectHello = {
    						hostAppGetPersonalizationInfo 			: getIllustratorUserJsonData,
    						hostAppOpenDoc						    : openExistingIllustratorDocument,
    						hostAppCreateNewDoc			            : openIllustratorDocumentOfType,
    						hostAppSetDoNotShowAgainPreference		: illuStratorSetHelloDontShowAgainPreference,
    						hostAppRetryLoadFromServer	            : illuStratorRetryLoadFromServer,
    						hostAppNotifyDoneWithUI		            : illuStratorNotifyDoneWithDialog,
    						hostAppNotifyFailedToLoad	            : illustratorNotifyFailedToLoad,
    						hostAppNotifyHTMLLayoutComplete			: illustratorNotifyFailedToLoad,
    						hostAppSendBackTest						: illustratorNotifyFailedToLoad,
							openURLInDefaultBrowser         		: illustratorOpenLinkInDefaultBrowser,
							hostAppNotifyInContentTutorial			: illustratorNotifyInContentTutorial,
                            hostAppNotifyContentTabChanged          : illustratorNotifyContentTabChanged
    						};
  

}

function getIllustratorUserJsonData(callback)
 {
		 var script = "app.getHelloJSONData()";
		 evalScript(script, callback);
 }

function evalScript(script, callback) {

	 if(callback == null || callback == undefined)
    {
        callback = function(result){};
    }
    if( window.__adobe_cep__)
	    window.__adobe_cep__.evalScript(script, callback);
    else
        callback(null);
}

function closeHello()
{
	if(window.__adobe_cep__)
    	window.__adobe_cep__.closeExtension();
}

function sendaboutToCloseEvents()
{
	var eventType  = "com.adobe.illustrator.welcome.aboutToAutomaticallyCloseHello";
	var eventData = "";
	sendEvent(eventType, eventData);
	
	logPIPEvent("ProjectHello", "Interaction", "DialogAutoDismiss");
}


function openExistingIllustratorDocument(fullPath)
{
	sendaboutToCloseEvents();

    if(fullPath == "open")
		sendExecuteMenuCommandEvent("open");
    else
    	sendRecentFileOpenEvent(fullPath);
	
    logPIPEvent("ProjectHello", "Interaction", "OpenExistingDoc");
	
	closeHello();
}

function openIllustratorDocumentOfType(documentType, suppressNewDocUI )
{

	sendaboutToCloseEvents();

	if(documentType == "From Template")
		sendExecuteMenuCommandEvent("newFromTemplate");
	else
	{
		var trueOrFalse = suppressNewDocUI ? "false" : "true";
		var script = "app.documents.addDocumentWithDialogOption(\""+documentType+"\"," +  trueOrFalse + ");";
		function callback(result)
		{
			
		}
		evalScript(script, callback);
	}
    
	logPIPEvent("ProjectHello", "Interaction", "CreateNewDoc");
    closeHello();
}

function illuStratorSetHelloDontShowAgainPreference(dontShowAgain)
{
	if( dontShowAgain )
		logPIPEvent("ProjectHello", "Interaction", "SetDoNotShowAgain");
	else
		logPIPEvent("ProjectHello", "Interaction", "ClearDoNotShowAgain");

	var trueOrFalse = dontShowAgain ? "true" : "false";

	var script = "app.preferences.setBooleanPreference(\"" + "Hello/DontShowAgainPrefKey_Ver18_1" +"\"," + trueOrFalse + ");";
	
	function callback(result)
	{
		
	}
	
	evalScript(script, callback);
}

function illuStratorRetryLoadFromServer()
{
	logPIPEvent("ProjectHello", "Interaction", "RetryPageLoad");
	if(window.navigator.onLine == true)
		window.location = "https://helpx.adobe.com/illustrator/hello/v1_6/";
}

function illuStratorNotifyDoneWithDialog()
{
    if(window.__adobe_cep__)
    {
    	logPIPEvent("ProjectHello", "Interaction", "dialogdoneCheck");
    	window.__adobe_cep__.closeExtension();
    }
}

function illustratorNotifyFailedToLoad(errorString)
{
	if( errorString )
		logPIPEvent("ProjectHello", "Failure", errorString);
}

function logPIPEvent(category, subCategory, eventName)
{
	var csInterface = new CSInterface();                   
	
	var pipLog = {

					"dataType" : "event",
					"category" : category,
					"subcategory": subCategory,
					"eventname": eventName
				};
	
	var event = new CSEvent();
	event.type = "com.adobe.illustrator.LOGPIP";
	event.scope = "APPLICATION";
	event.data = JSON.stringify(pipLog);
	event.appId = "ILST";
	event.extensionId = "com.illustrator.Welcome.extension1";
				  
	csInterface.dispatchEvent(event);  
}

function sendRecentFileOpenEvent(fileName)
{
	var csInterface = new CSInterface();                   
	
	var event = new CSEvent();
	event.type = "com.adobe.illustrator.welcome.HandleRecentFileOpen";
	event.scope = "APPLICATION";
	event.data = fileName;
	event.appId = "ILST";
	event.extensionId = "com.illustrator.Welcome.extension1";
				  
	csInterface.dispatchEvent(event);  
}
function sendExecuteMenuCommandEvent(menuString)
{
	var csInterface = new CSInterface();                   
	
	var event = new CSEvent();
	event.type = "com.adobe.illustrator.HandleExecuteMenuCommand"
	event.scope = "APPLICATION";
	event.data = menuString;
	event.appId = "ILST";
	event.extensionId = "com.illustrator.Welcome.extension1";
				  
	csInterface.dispatchEvent(event);  
}

function illustratorOpenLinkInDefaultBrowser(url)
{
  if(window.cep.util.openURLInDefaultBrowser)
  {
    window.cep.util.openURLInDefaultBrowser(url);
    logPIPEvent("ProjectHello", "Interaction", "OpenExtLink:" + url);
  }
}

function sendEvent(eventType, eventData)
{
	var csInterface = new CSInterface();                   
	
	var event = new CSEvent();
	event.type = eventType;
	event.scope = "APPLICATION";
	event.data = eventData;
	event.appId = "ILST";
	event.extensionId = "com.illustrator.Welcome.extension1";
													  
	csInterface.dispatchEvent(event);  
}

function illustratorNotifyInContentTutorial(isInContentTutorial)
{
	var eventType  = "com.adobe.illustrator.welcome.isInContentTutorialNotification";
	var eventData = isInContentTutorial ? "Yes" : "No";
	sendEvent(eventType, eventData);
}

function illustratorNotifyContentTabChanged(currentTab)
{
	var eventType  = "com.adobe.illustrator.welcome.contentTabChangedNotification";
	var eventData = "";
	sendEvent(eventType, eventData);
}
