/**
 * Lo-Dash 2.4.1 (Custom Build) <http://lodash.com/>
 * Build: `lodash modern strict modularize`
 * Copyright 2012-2013 The Dojo Foundation <http://dojofoundation.org/>
 * Based on Underscore.js 1.5.2 <http://underscorejs.org/LICENSE>
 * Copyright 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 * Available under MIT license <http://lodash.com/license>
 */
define(['../functions/createCallback', './forOwn'], function(createCallback, forOwn) {

  'use strict';

  /**
   * Creates an object with the same keys as `object` and values generated by
   * running each own enumerable property of `object` through the callback.
   * The callback is bound to `thisArg` and invoked with three arguments;
   * (value, key, object).
   *
   * If a property name is provided for `callback` the created "_.pluck" style
   * callback will return the property value of the given element.
   *
   * If an object is provided for `callback` the created "_.where" style callback
   * will return `true` for elements that have the properties of the given object,
   * else `false`.
   *
   * @static
   * @memberOf _
   * @category Objects
   * @param {Object} object The object to iterate over.
   * @param {Function|Object|string} [callback=identity] The function called
   *  per iteration. If a property name or object is provided it will be used
   *  to create a "_.pluck" or "_.where" style callback, respectively.
   * @param {*} [thisArg] The `this` binding of `callback`.
   * @returns {Array} Returns a new object with values of the results of each `callback` execution.
   * @example
   *
   * _.mapValues({ 'a': 1, 'b': 2, 'c': 3} , function(num) { return num * 3; });
   * // => { 'a': 3, 'b': 6, 'c': 9 }
   *
   * var characters = {
   *   'fred': { 'name': 'fred', 'age': 40 },
   *   'pebbles': { 'name': 'pebbles', 'age': 1 }
   * };
   *
   * // using "_.pluck" callback shorthand
   * _.mapValues(characters, 'age');
   * // => { 'fred': 40, 'pebbles': 1 }
   */
  function mapValues(object, callback, thisArg) {
    var result = {};
    callback = createCallback(callback, thisArg, 3);

    forOwn(object, function(value, key, object) {
      result[key] = callback(value, key, object);
    });
    return result;
  }

  return mapValues;
});
