/*global define, console, require */
/*jslint white: true */

define (["jquery-require",	"lodash"],
function(jQuery,			lodash) {
	'use strict';

	var isFunction = lodash.isFunction,
		forEach = lodash.forEach,
		functions = lodash.functions,
		rest = lodash.rest;

	function assert (condition, message0) {
		var message = message0 || "";

		if (condition) {
			return condition;
		}

		console.log("failed assert: " + message);
		throw(new Error(message));
	}

	function clone (deep, dst0, src) {
		var dst = dst0 || {};

		assert(deep === true || deep === false);
		if (deep === true) {
			// jQuery extend doesn't work if you pass the first parameter as false.
			// Instead of avoiding a deep copy, it gets the wrong target.
			return jQuery.extend(deep, dst, src);
		}
		return jQuery.extend(dst, src);
	}

	function copy (src, dst0) {
		return clone(false, dst0, src);
	}

	// pass dest followed by n sources to mixin; each can either be a constructor function or a prototype
	function mixin (destination) {
		var dstObject = isFunction(destination) ? destination.prototype : destination;

		forEach(rest(arguments), function (source) {
			var srcObject = source, 
				sourceIsConstructor = isFunction(source),
				methodNames;

			if (sourceIsConstructor) {
				dstObject[source.name] = source;
				srcObject = source.prototype;
			}
			methodNames = srcObject && functions(srcObject);
			forEach(methodNames, function(methodName) {
				if (sourceIsConstructor && methodName === "constructor") { 
					// TODO: we could just skip it, but for now i'd like to know about every occurence
					throw new TypeError("mixin: function with enumerable constructor won't preserve semantics of the constructor property."); 
				}
				dstObject[methodName] = srcObject[methodName];
			});

		});
	}

	return {
		assert : assert,
		clone : clone,
		copy : copy,
		mixin : mixin
	};
});
