/*global define, describe, it, expect, beforeEach, afterEach */
/*jslint white: true */

define (["src/math/Mat3",	"src/math/Vec2"],
function(mat3, 				vec2) {
	'use strict';

	return function() {
		describe("vec2", function () {
			it("should create object with array methods", function () {
				expect(vec2([1, 1]).slice).toBeDefined();
				expect(vec2([1, 1]).forEach).toBeDefined();
			});

			it("should create object with vector methods", function () {
				expect(vec2([1, 1]).init).toBeDefined();
			});

			it("should implement equality test", function () {
				var u = vec2([1, 2]);
				expect(u.equals([1, 2])).toBe(true);
				expect(u.equals([2, 2])).toBe(false);
				expect(u.equals([1, 1])).toBe(false);
				expect(vec2([1, 2]).equals([1, 2])).toBe(true);
				expect(vec2([1, 2]).equals([2, 2])).toBe(false);
				expect(vec2([1, 2]).equals([1, 1])).toBe(false);
			});

			it("should initialize objects correctly", function () {
				var zeros = [0, 0],
					ones = [1, 1],
					u = vec2(zeros);
				u.init(1, 1);
				expect(u.equals(ones)).toBe(true);
				expect(vec2(zeros).init(1, 1).equals(ones)).toBe(true);
			});

			it("should clone objects", function () {
				var ones = [1, 1],
					u = vec2(ones),
					v;
				v = u.clone();
				expect(u).toBe(ones);
				expect(u.equals(ones)).toBe(true);
				expect(v).not.toBe(ones);
				expect(v.equals(u)).toBe(true);
			});

			it("object methods should match free functions", function () {
				var u = vec2([1, 3]);

				expect(u.clone().axpy(2, [3, 1]).equals([5, 7])).toBe(true);
				expect(u.clone().normalize().equals(vec2.normalize(u.clone(), u.clone()))).toBe(true);
				expect(u.clone().scale(2).equals([2, 6])).toBe(true);
				expect(u.clone().dot([2, 4])).toEqual(14);
				expect(u.clone().negate().equals(vec2.negate(u))).toBe(true);
				expect(u.clone().xdy([0.5, 0.2]).equals([2, 15])).toBe(true);
			});

		});

		describe("mat3", function () {
			it("should create object with array methods", function () {
				expect(mat3(mat3.identity()).slice).toBeDefined();
				expect(mat3(mat3.identity()).forEach).toBeDefined();
			});
			it("should create object with vector methods", function () {
				expect(mat3(mat3.identity()).init).toBeDefined();
			});
			it("should implement equality test", function () {
				var zero = mat3.zero(),
					identity = mat3.identity(),
					a = mat3(identity);
				expect(a.equals(identity)).toBe(true);
				expect(a.equals(zero)).toBe(false);
				expect(mat3(identity).equals(identity)).toBe(true);
				expect(mat3(identity).equals(zero)).toBe(false);
			});

			it("should initialize objects correctly", function () {
				var zero = mat3.zero(),
					identity = mat3.identity(),
					a = mat3(zero);
				a.init(1, 0, 0, 0, 1, 0, 0, 0, 1);
				expect(a.equals(identity)).toBe(true);
				expect(mat3(zero).init(1, 0, 0, 0, 1, 0, 0, 0, 1).equals(identity)).toBe(true);
			});

			it("should clone objects", function () {
				var identity = mat3.identity(),
					u = mat3(identity),
					v;
				v = u.clone();
				expect(u).toBe(identity);
				expect(u.equals(identity)).toBe(true);
				expect(v).not.toBe(identity);
				expect(v.equals(u)).toBe(true);
			});

		});

	};
});
