/*global define, require */
/*jslint white: true */

/*
	curve utils:

	This file implements curve related utilities.
*/

define	([	"src/math/mathUtils",	"src/math/curveUtils"],
function(	mathUtils,				curveUtils) {
	'use strict';

	// Returns wether to cancel recursion.  -jacquave
	function invokeCurveEvaluatorRecurse(inCurveEvaluator, inCurve, inMinT, inMaxT, inDepth) {
		var func = inCurveEvaluator.recurse, output;
		if (typeof func === 'function') {
			output = func(inCurve, inMinT, inMaxT, inDepth);
		}
		return output;
	}

	// Returns wether to cancel recursion.  -jacquave
	function invokeCurveEvaluatorAddPoint(inCurveEvaluator, inCurve, inT, inCurveIndex) {
		var func = inCurveEvaluator.addPoint, output;
		if (typeof func === 'function') {
			output = func(inCurve, inT, inCurveIndex);
		}
		return output;
	}

	function evaluateCurveAdaptivelyInRange(inTMin, inTMax, inCurveIndex, inDepth, inCurve, inCurveEvaluator) {
		var tMid = mathUtils.lerp(inTMin, inTMax, 0.5);

		if (!invokeCurveEvaluatorRecurse(inCurveEvaluator, inCurve, inTMin, inTMax, inDepth)) {
			if (inDepth > 0) {
				invokeCurveEvaluatorAddPoint(inCurveEvaluator, inCurve, tMid, inCurveIndex);
			}
		} else {
			evaluateCurveAdaptivelyInRange(inTMin, tMid, inCurveIndex, inDepth + 1, inCurve, inCurveEvaluator);
			evaluateCurveAdaptivelyInRange(tMid, inTMax, inCurveIndex, inDepth + 1, inCurve, inCurveEvaluator);
		}
	}

	// Fit a curve to an array of points.
	function evaluateCurveAdaptively(inCurve, inCurveEvaluator, inTMin, inTMax, inCurveIndex) {
		var	depth = 0;
		inCurveIndex = inCurveIndex || 0;
		inTMin = inTMin || 0.0;
		inTMax = inTMax || 1.0;
		invokeCurveEvaluatorAddPoint(inCurveEvaluator, inCurve, inTMin, inCurveIndex);
		evaluateCurveAdaptivelyInRange(inTMin, inTMax, inCurveIndex, depth, inCurve, inCurveEvaluator);
		invokeCurveEvaluatorAddPoint(inCurveEvaluator, inCurve, inTMax, inCurveIndex);
	}

	// Fit curve2 to an array of points.
	function evaluateCurvesAdaptively(inCurveArray, inCurveEvaluator) {
		var	i;

		for (i = 0; i < inCurveArray.length; i += 1) {
			evaluateCurveAdaptively(inCurveArray[i], inCurveEvaluator, 0.0, 1.0, i);
		}
	}

	function linearCurveAdaptEvaluator(outTValues, inMaxDepth, inCurveTolerance) {
		inMaxDepth = inMaxDepth || 6;
		return {
			addPoint : function (inCurve, inT, inCurveIndex) {
				if (outTValues !== undefined) {
					outTValues.push(inT);
				}
			},
			recurse : function (inCurve, inMinT, inMaxT, inDepth) {
				var result = inDepth <= inMaxDepth;
				if (result === true) {
					return !curveUtils.isLinear(inCurve, inMinT, inMaxT, inCurveTolerance);
				}
				return result;
			}
		};
	}

	function linearCurvesAdaptEvaluator(outTValues, inMaxDepth, inCurveTolerance) {
		var result = linearCurveAdaptEvaluator(outTValues, inMaxDepth, inCurveTolerance);

		result.addPoint = function (inCurve, inT, inCurveIndex) {
			if (outTValues !== undefined) {
				outTValues.push({t : inT, curveIndex : inCurveIndex});
			}
		};
		return result;
	}



	return {
		// Fit a curve to an array of points.
		evaluateCurveAdaptively : evaluateCurveAdaptively,
		evaluateCurvesAdaptively : evaluateCurvesAdaptively,
		linearCurveAdaptEvaluator : linearCurveAdaptEvaluator,
		linearCurvesAdaptEvaluator : linearCurvesAdaptEvaluator
	};
});
