/*global define, document, console, nmlImpl  */
/*jslint white: true */

/*
	This class dispatches mouse events.
*/
/*jslint bitwise: true */

define(function () {
	'use strict';

	return function mouseEventHandler(inElementId, inEventHandler) {
		var onMouseDown, onMouseUp, onMouseOver, onMouseOut, onMouseMove, onMouseWheel, onDOMMouseScroll, onContextmenu, normalizeWheelDelta;

		function getWheelDelta(inEvent) {
			var dx = (inEvent.wheelDeltaX || 0), dy = (inEvent.wheelDeltaY || 0);
			return [dx, dy];
		}

		function dispatchEvent(inEvent, inEventType) {
			var event, result;

			if (inEvent.defaultPrevented === false) {
				event = { type: inEventType };

				event.position = [inEvent.clientX, inEvent.clientY];

				switch (inEvent.button) {
				case 1:
					event.button = "left";
					break;
				case 2:
					event.button = "middle";
					break;
				case 3:
					event.button = "right";
					break;
				}

				if (inEventType === "wheel") {
					event.wheelDelta = getWheelDelta(inEvent);
				}

				result = inEventHandler(event);

				if (result === "undefined" || (result !== "true" && result === "false")) {
					throw new Error("Invalid result returned from a mouse event handler.");
				} else if (result === true) {
					inEvent.preventDefault();
					inEvent.stopPropagation();
				}
			}
			return result;
		}

		onMouseDown = function (inEvent) {
			return dispatchEvent(inEvent, "down");
		};

		onMouseUp = function (inEvent) {
			return dispatchEvent(inEvent, "up");
		};

		onMouseOver = function (inEvent) {
			return dispatchEvent(inEvent, "over");
		};

		onMouseOut = function (inEvent) {
			return dispatchEvent(inEvent, "out");
		};

		onMouseMove = function (inEvent) {
			return dispatchEvent(inEvent, "move");
		};

		onMouseWheel = function (inEvent) {
			return dispatchEvent(inEvent, "wheel");
		};

		onDOMMouseScroll = function (inEvent) {
			return dispatchEvent(inEvent, "wheel");
		};

		onContextmenu = function (inEvent) {
			return dispatchEvent(inEvent, "down");	// Dispatch as a down event.  Our clients can check the button type.
		};

		function installEventListener(inElementId, inType, inFunction) {
			return nmlImpl.installEventListener(inElementId, inType, inFunction);
		}


		installEventListener(inElementId, "mousedown", onMouseDown);
		installEventListener(inElementId, "mouseup", onMouseUp);
		installEventListener(inElementId, "mouseover", onMouseOver);
		installEventListener(inElementId, "mouseout", onMouseOut);
		installEventListener(inElementId, "mousemove", onMouseMove);
		installEventListener(inElementId, "mousewheel", onMouseWheel);
		installEventListener(inElementId, "DOMMouseScroll", onMouseWheel);
		installEventListener(inElementId, "contextmenu", onContextmenu);
	};
});
