/*global define */
/*jslint white: true */

/*
	ContainerStore:

	This object provides Container creation within its hierarchy.
*/

define  ([  "src/utils", "src/build/Container"],
function(   utils, Container) {
	"use strict";

	function identity (obj) {
		return obj;
	}

	function mixin (traits0) {
		var traits = traits0 || {},
			dataStore = traits.getDataStore || identity,
			p;

		function getRenameMethodName(inName) {
			if (traits.rename && traits.rename[inName]) {
				inName = traits.rename[inName] || inName;
			}
			return inName;
		}
		
		function getRenameMethod(inObj, inName) {
			return inObj[getRenameMethodName(inName)];
		}

		function addChildToParent(inParent, inChild) {
			// This needs to insert the child in the correct 
			// order based on the ordering specified by the other hierarchy. -jacquave
			inParent.addChild(inChild);
		}
		
		p = {};
		
		p[getRenameMethodName("getContainer")] = 
			function () {
				var dataObj = dataStore(this);
				if (dataObj.createsContainersB && !dataObj.container0) {
					dataObj.container0 = traits.createContainer.call(this, dataObj.containerName0);
					traits.setEnabled(dataObj.enableByDefaultB, dataObj.container0);
				}

				return dataObj.container0;
			};
		
		p[getRenameMethodName("setContainer")] = 
			function (inContainer0) {
				var dataObj = dataStore(this);
				dataObj.container0 = inContainer0;
			};
		
		p[getRenameMethodName("getParentContainer")] = 
			function () {
				var dataObj = dataStore(this);
				var p0 = this.getParent();
				if (p0) {
					if (getRenameMethod(p0, "getContainer")) {
						return getRenameMethod(p0, "getContainer").call(p0);
					}
					if (getRenameMethod(p0, "getParentContainer")) {
						return getRenameMethod(p0, "getParentContainer").call(p0);
					}
				}
				return null;
			};
		
		p[getRenameMethodName("attachToRootContainer")] = 
			function (inRoot) {
				var dataObj = dataStore(this);
				var c0 = getRenameMethod(this, "getContainer").call(this), pc0, p0;
				p0 = this.getParent();
				while (p0) {
					pc0 = getRenameMethod(p0, "getContainer") ? getRenameMethod(p0, "getContainer").call(p0) : null;
					if (pc0) {
						// attach
						if (c0.getParent() !== pc0) {
							addChildToParent(pc0, c0);
						}
						c0 = pc0;
					}
					p0 = p0.getParent ? p0.getParent() : null;
				}

				if (c0 && c0.getParent() !== inRoot) {
					addChildToParent(inRoot, c0);
				}
			};
		
		return p;
	}

	return mixin;
});

