/*global define */
/*jslint white: true, nomen: true */


define (
function() {
	'use strict';

	function identity (obj) {
		return obj;
	}

	function mixin (options0) {
		var options = options0 || {},
			changeNotifiersL_ = options.notifiersLabel || "changeNotifiers_",
			treeInfo_ = options.getTreeInfo || identity;

		return {
			addChangeNotifier : function (inNotifierId, inNotifier) {
				var info = treeInfo_(this), c, addNotifier, cId;
				if (info[changeNotifiersL_] === undefined) {
					info[changeNotifiersL_] = [];
				}

				addNotifier = { id: inNotifierId, notifier: inNotifier };
				for (c = 0; c < info[changeNotifiersL_].length; c += 1) {
					cId = info[changeNotifiersL_][c].id;

					if (cId === inNotifierId) {
						if (inNotifier === undefined) {
							info[changeNotifiersL_].splice(c, 1);
						} else {
							info[changeNotifiersL_][c] = addNotifier;
						}
						return;
					}
				}
				info[changeNotifiersL_].push(addNotifier);
			},

			callChangeNotifiers : function (msgType, params) {
				var info = treeInfo_(this), c, n, changedFunc;
				if (info[changeNotifiersL_] !== undefined) {
					for (c = 0; c < info[changeNotifiersL_].length; c += 1) {
						n = info[changeNotifiersL_][c];
						changedFunc = n.notifier[msgType];

						if (typeof changedFunc === 'function') {
							changedFunc.call(n.notifier, this, params);
						}
					}
				}
			},

			getChangeNotifier : function (inNotifierId) {
				var info = treeInfo_(this), c, cId;
				if (info[changeNotifiersL_] !== undefined) {
					for (c = 0; c < info[changeNotifiersL_].length; c += 1) {
						cId = info[changeNotifiersL_][c].id;

						if (cId === inNotifierId) {
							return info[changeNotifiersL_][c].notifier;
						}
					}
				}
				return undefined;
			}            
			
		};
	}

	

	return mixin;
});
