/*
	Puppet:

	This object represents the puppet on the stage.
*/

define(["src/utils", "lodash"],
function (utils, lodash) {
	"use strict";

	var now = nmlImpl.getCurrentTime,
		min = Math.min,
		max = Math.max;

	var zones, stack, reportBegin;
	function reset () {
		zones = {};
		stack = [];
		reportBegin = false;
	}
	reset();

	return {
		push : function (name) {
			var zone = zones[name] || {
				name : name,
				total : 0.0,
				avg : 0.0,
				min : Infinity,
				max : 0.0,
				calls : 0,
				begin : []
			};
			zones[name] = zone;
			stack.push(name);
			zone.calls += 1;
			zone.begin.push(now());
		},

		pop : function () {
			var name = stack.pop();
			utils.assert(name);
			var zone = zones[name],
				dt = now() - zone.begin.pop();

			zone.total += dt;
			zone.avg = zone.total / zone.calls;
			zone.min = min(zone.min, dt);
			zone.max = max(zone.max, dt);
		},

		report : function (period) {
			var t = now();

			if ( reportBegin ) {
				if (t - reportBegin > period) {
					lodash.forOwn(zones, function (zone, name) {
						console.logToUser("name: " + name + ",\tcalls: " + zone.calls + ",\ttotal: " + zone.total + "s,\tavg: " + zone.avg*1000 + "ms,\tmax: " + zone.max*1000 + "ms,\tmin: " + zone.min*1000 + "ms");
					});
					reportBegin = t;
				}
			} else {
				reportBegin = t;
			}
		},

		reset : reset
	};
});
