/*global define */
/*jslint white: true */

/*
	TrackItemSource:

	This object contains information regarding a track item's source.
*/

define (["src/utils"],
function(utils) {
	'use strict';

	function TrackItemSource(inPPathString, inClassInstance, inJsonPath) {
		utils.assert(this !== undefined, "TrackItemSource not called with new.");
		// do not modify these private members directly or notifiers won't be called correctly
		this.pTrackItemSourceData = { 
			ppathString			: inPPathString, 
			classInstance		: inClassInstance,
			jsonPath			: inJsonPath
		};
	}

	utils.mixin(TrackItemSource, {
		clone : function (clone_children, other) {
			var result = other;

			if (result) {
				// init
				TrackItemSource.call(result);
			} else {
				// alloc and init
				result = new TrackItemSource();
			}

			utils.clone(false, result.pTrackItemSourceData, this.pTrackItemSourceData);

			return result;
		},

		// Get the PPath String
		getPPathString : function () {
			return this.pTrackItemSourceData.ppathString;
		},
		
		// Get the class instance String
		getClassInstance : function () {
			return this.pTrackItemSourceData.classInstance;
		},
		
		// Get the Json path
		getJsonPath : function () {
			return this.pTrackItemSourceData.jsonPath;
		}
	});

	return TrackItemSource;
});
