/*global define, require */
/*jslint white: true */

/*
	Track:

	This object provides a mixin for each scene Track.
*/

define(["src/utils", "src/build/treeLeaf", "src/build/TimeItem", "src/build/treeContainer", "src/build/changeNotifier",
		"src/build/AudibleItem", "src/build/VisibleItem", "src/build/DisplayContainerStorage", "src/build/AudioContainerStorage"],
function(utils, treeLeaf, TimeItem, treeContainer, changeNotifier, AudibleItem, VisibleItem, DisplayContainerStorage, AudioContainerStorage) {
	'use strict';

	var TimeItem_clone = TimeItem.prototype.clone;

	function Track(inTrackName, inEphemeralB) {
		this.TimeItem("TimeItem");
		this.AudibleItem("AudibleItem");
		this.VisibleItem("VisibleItem");
		this.DisplayContainerStorage(true, true, inTrackName + " Track Display Container");
		this.AudioContainerStorage(true, true, inTrackName + " Track Audio Container");

		this.m_trackItems = [];
		// do not modify these private members directly or notifiers won't be called correctly
		this.pTrack = { 
			name			: inTrackName,
			parent			: undefined,
			changeNotifiers : undefined,
			ephemeral		: inEphemeralB || false,
			armedForRecord	: false
		};
	}

	utils.mixin(Track, TimeItem, AudibleItem, VisibleItem, DisplayContainerStorage, AudioContainerStorage,
		treeLeaf({ 
			parentLabel   : "parent", 
			getTreeInfo : function (obj) { return obj.pTrack; }		
		}),

		changeNotifier({
			notifiersLabel: "changeNotifiers",
			getTreeInfo: function (obj) { return obj.pTrack; }		
		}),

		treeContainer({ childrenLabel   : "m_trackItems" }),

		{
			setName : function (name) {
				this.pTrack.name = name;
				this.callChangeNotifiers("nameChanged");
			},

			// const return value
			getName : function () {
				return this.pTrack.name;
			},
			
			// is this a dynamic track, used for creating dynamic elements
			isEphemeral : function () {
				return this.pTrack.ephemeral;
			},

			setArmedForRecord : function (inSetArmedForRecord) {
				this.pTrack.armedForRecord = inSetArmedForRecord;
			},

			getArmedForRecord : function () {
				return this.pTrack.armedForRecord;
			},

		// function types:
			// "nameChanged"
			// "parentChanged"
			// "volumeChanged"
			// "childAdded"
			// "childRemoved"
			clone : function (clone_children, other) {
				var result = other, i, ti;

				if (result) {
					// init
					Track.call(result);
				} else {
					// alloc and init
					result = new Track();
				}

				// clone time item state
				TimeItem_clone.call(this, clone_children, result);

				utils.clone(false, result.pTrack, this.pTrack);
				delete result.pTrack.parent;
				delete result.pTrack.changeNotifiers;
				result.setParent(undefined);

				// copy (by default) container children...
				if (clone_children === undefined || clone_children) {
					for (i = 0; i < this.m_trackItems.length; i += 1) {
						ti = this.m_trackItems[i];
						ti = ti.clone(clone_children);
						result.m_trackItems[i] = ti;
						ti.setParent(result);
					}
				}

				return result;
			}
		});

	return Track;
});
