/*global define */
/*jslint white: true */

/*
	TimeItem:

	This object provides a mixin for each time based item.
*/

define(["src/utils"],
function(utils) {
	'use strict';

	function TimeStack() {
		utils.assert(this !== undefined, "TimeStack not called with new.");
		this.pTimeStack = [];
	}

	function getTopTimeStackItem(inTimeStack) {
		utils.assert(inTimeStack.pTimeStack.length, "getTopTimeStackItem called with an empty stack");
		return inTimeStack.pTimeStack[inTimeStack.pTimeStack.length - 1];
	}

	function getBottomTimeStackItem(inTimeStack) {
		utils.assert(inTimeStack.pTimeStack.length, "getBottomTimeStackItem called with an empty stack");
		return inTimeStack.pTimeStack[0];
	}
	
	utils.mixin(TimeStack, {
		getSize : function () {
			return this.pTimeStack.length;
		},

		getLocalTimeSpan : function () {
			var	timeSpan;
			timeSpan = getTopTimeStackItem(this).itemTimeSpan;
			return timeSpan;
		},

		getParentTimeSpan : function () {
			var	timeSpan;
			timeSpan = getTopTimeStackItem(this).parentTimeSpan;
			return timeSpan;
		},

		getRootTimeSpan : function () {
			var	timeSpan;
			timeSpan = getBottomTimeStackItem(this).parentTimeSpan;
			return timeSpan;
		},

		pushTime : function (inParent, inChild, inRootTimeSpan0) {
			var	parentTimeSpan = inRootTimeSpan0, localTimeSpan;
			
			if (parentTimeSpan === undefined) {
				parentTimeSpan = this.getLocalTimeSpan();
			}
			if (inChild && inChild.convertToLocalTime) {
				utils.assert(parentTimeSpan !== undefined, "invalid time passed to pushTimeStack");
				localTimeSpan = inChild.convertToLocalTime(parentTimeSpan, inParent);
			} else {
				localTimeSpan = {t:parentTimeSpan.t, dt:parentTimeSpan.dt};
			}
			this.pTimeStack.push({item:inChild, parent:inParent, parentTimeSpan:parentTimeSpan, itemTimeSpan:localTimeSpan});
			return localTimeSpan;
		},

		popTime : function () {
			utils.assert(this.pTimeStack.length, "popTimeStack called with an empty stack");
			this.pTimeStack.pop();
		}
	});

	return TimeStack;
});
