/*global define, require */
/*jslint white: true */

/*
	SceneItem:

	This object provides a mixin for each item that exists within a Scene.
*/

define(["src/utils", "src/build/treeLeaf", "src/build/changeNotifier"],
function(utils, treeLeaf, changeNotifier) {
	'use strict';

	function SceneItem() {
		utils.assert(this !== undefined, "SceneItem not called with new.");

		// do not modify these private members directly or notifiers won't be called correctly
		this.pSceneItem = { 
			parent          : undefined,
			changeNotifiers	: undefined
		};
	}

	utils.mixin(SceneItem, 
		treeLeaf({ 
			parentLabel   : "parent", 
			getTreeInfo : function (obj) {	return obj.pSceneItem;	}
		}),

		changeNotifier({
			notifiersLabel: "changeNotifiers",
			getTreeInfo: function (obj) { return obj.pSceneItem; }
		}),
		{
			// function types:
			// "parentChanged"
			// "childAdded"
			// "childRemoved"
			clone : function (clone_children, other) {
				var result = other;

				if (result) {
					// init
					SceneItem.call(result);
				} else {
					// alloc and init
					result = new SceneItem();
				}

				utils.clone(false, result.pSceneItem, this.pSceneItem);

				delete result.pSceneItem.parent;
				delete result.pSceneItem.changeNotifiers;
				result.setParent(undefined);

				return result;
			}
		}
	);


	return SceneItem;
});
