/*
	Layerish:

	This mixin object comprises the things common to Layers and TrackItems.
	
*/

define(["src/utils", "src/build/Puppet"],
function(utils, Puppet) {
	"use strict";

	return {
		getPuppet : function () {
			var pup = this.getSource();
			return pup.constructor === Puppet ? pup : null;
		},

		// calls the given function once for each layer, in front-to-back order
		// starts with the "this" layer (TrackItem which acts like a layer) and includes all children of sources; return false from fn to stop iterating
		//	based on more general treeContainer.js version, but we can't use the entire treeContainer mixin because (1) we don't want a writable
		//	tree, and (2) we don't want a parallel tree one level off of layers (vs. items). Similar to forEachLayerBreadthFirst, but that one
		//	is on SdkLayers, this one on internal Layers
		breadthFirstEachLayer : function (fn) {
			var i, node, sourcePuppet, children,
				queue = [ this ];

			while (queue.length > 0) {
				node = queue.shift();
				if (fn(node) === false) { break; }
				sourcePuppet = node.getPuppet();

				if (sourcePuppet) {
					children = sourcePuppet.getLayers();
					for (i = children.length - 1; i >= 0 ; i -= 1) {	// reverse order because children are in back to front order
						queue.push(children[i]);
					}
				}
			}

			return this;
		}
	};
});