/*global define, require */
/*jslint white: true */

/*
	EventGraphPileItem:

	This object defines the event graph pile item, which represents a referenced to a event recording file.
*/

define(["src/utils", "src/build/treeLeaf", "src/build/TimeItem"],
function(utils, treeLeaf, TimeItem) {
	'use strict';

	var TimeItem_clone = TimeItem.prototype.clone;
	
	function EventGraphPileItem(inEnabled, inSolo, inBoundBehaviorId, inBoundInstanceId, inParamId, inFilePath) {
		this.TimeItem("TimeItem");

		// do not modify these private members directly or notifiers won't be called correctly
		this.pPileItem = { 
			parent				: undefined,
			enabledB			: inEnabled,
			soloB				: inSolo,
			boundBehaviorId		: inBoundBehaviorId,
			boundInstanceId 	: inBoundInstanceId,
			paramId				: inParamId,
			filePath			: inFilePath
		};
	}

	utils.mixin(EventGraphPileItem, TimeItem,
		treeLeaf({ 
			parentLabel   : "parent", 
			getTreeInfo : function (obj) { return obj.pPileItem; }		
		}),

		{
			isEnabled : function () {
				return this.pPileItem.enabledB;
			},

			isSolo : function () {
				return this.pPileItem.soloB;
			},

			getBoundBehaviorId : function () {
				return this.pPileItem.boundBehaviorId;
			},

			getBoundInstanceId : function () {
				return this.pPileItem.boundInstanceId;
			},
		
			getParamId : function () {
				return this.pPileItem.paramId;
			},

			getFilePath : function () {
				return this.pPileItem.filePath;
			},

			clone : function (clone_children, other) {
				var result = other, i;

				if (result) {
					// init
					EventGraphPileItem.call(result);
				} else {
					// alloc and init
					result = new EventGraphPileItem();
				}

				// clone time item state
				TimeItem_clone.call(this, clone_children, result);

				utils.clone(false, result.pPileItem, this.pPileItem);

				delete result.pPileItem.parent;
				result.setParent(undefined);

				return result;
			}
		});


	return EventGraphPileItem;
});
