/*global define */

/*
	DisplayContainerStorage:

	This object provides a mixin for each item that can create a view container.
*/

define  ([  "src/utils", "src/build/Container", "src/build/containerStorage"],
function(   utils, Container, containerStorage) {
	"use strict";

	function DisplayContainerStorage(inCreatesContainers0, inVisibleByDefault0, inContainerName0) {
		utils.assert(this !== undefined, "DisplayContainerStorage not called with new.");
		// do not modify these private members directly or notifiers won't be called correctly
		this.pDisplayContainerStorage = {
			createsContainersB	: (inCreatesContainers0 === undefined) ? false : inCreatesContainers0,
			containerName0		: inContainerName0,
			enableByDefaultB	: (inVisibleByDefault0 === undefined) ? true : inVisibleByDefault0,
			container0			: null
		};
	}

	var containerStorageMixin = containerStorage({
		getDataStore : function (obj) {
			return obj.pDisplayContainerStorage;
		},
		createContainer : function (inName0) {
			return new Container(inName0);
		},
		setEnabled : function (inEnableB, ioContainer) {
			ioContainer.setVisibleEnabled(inEnableB);
		},
		rename		: {	getContainer : "getDisplayContainer",
						setContainer : "setDisplayContainer",
						getParentContainer : "getParentDisplayContainer",
						attachToRootContainer : "attachToRootDisplayContainer"},
	});

	utils.mixin(DisplayContainerStorage, containerStorageMixin);
	
	return DisplayContainerStorage;
});
