/*
	Container:

	This object provides a mixin for each node container.
*/

define ([   "src/build/Node",   "src/math/Mat3",			"src/math/Vec2",
			"src/utils",		"src/build/treeContainer",	"lodash"],
function(	Node,				mat3,						vec2,
			utils,				treeContainer,				lodash) {
	"use strict";

/* TODO: uncomment, test, and use
	function calcBarycentricLocation(points, triangle, location, result0) {
		var i = 2*triangle[0],
			j = 2*triangle[1],
			k = 2*triangle[2],

			pi = points.slice(i, i+2),
			pj = points.slice(j, j+2),
			pk = points.slice(k, k+2),

			lk = vec2.subtract(location, pk),

			xki = pi[0] - pk[0],
			ykj = pj[1] - pk[1],
			xjk = pk[0] - pj[0],
			yik = pk[1] - pi[1],

			result = result0 || [],

			den = ykj * xki - xjk * yik;

		result[0] = ykj * lk[0] + xjk * lk[1] / den;
		result[1] = yik * lk[0] + xki * lk[1] / den;
		result[2] = 1 - result[0] - result[1];

		return result;
	}

	function isBarycentricLocationInsideTriangle (location) {
		return location[0] >= 0 && location[0] <= 1 
			&& location[1] >= 0 && location[1] <= 1 
			&& location[2] >= 0 && location[2] <= 1;
	}
*/
	var WarpDomain = {
			BOX    : "box",
			CONTOUR: "contour",
		},
		Node_clone = Node.prototype.clone;

	function Warper () {
		this.restMatParent_Puppet = null;
		this.aRestMatPuppet_Handle = [];
		this.aRestMatHandle_Puppet = [];
		this.warpDomain = WarpDomain.BOX;
		this.warpMeshExpansion = 0;
		this.didSetContainerMatrix = false;
		this.canWarp = false;
	}

	utils.mixin(Warper, 
		// Keep in sync with Stage.cpp
		{
			/** 
			 * Get handles that determine available DOFs in the warping container.
			 * @return array of handles
			 */
/* TODO: obsolete, remove
			getHandles : function () {
				return this.handles;
			},
*/			

			canInitialize : function () {
				if (this.restMatParent_Puppet) {
					return this.aRestMatPuppet_Handle.length > 1;
				}

				return false;
			},

			getRestLocations : function () {
				var aRestMatPuppet_Handle = this.aRestMatPuppet_Handle;
				if (aRestMatPuppet_Handle) {
					// no modification allowed
					return lodash.map(this.aRestMatPuppet_Handle, function (mi) {
						return mat3.getTranslation(mi);
					});
				}
				// no handle locations available: forgot call to initWarp()?
				utils.assert(false, "getRestLocations(): missing rest configuration.");
			},

		});

	function Container(inName) {
		this.Node("Container", inName);
		this.m_children = [];

		this.privateWarper = new Warper();
	}

	Container.WarpDomain = WarpDomain;

	utils.mixin(Container, 
		Node,
		treeContainer({ 
			childrenLabel   : "m_children"
		}),
		{
			exclusivelyEnableChild :function (inChildName) {
				var c, foundNode, nodesToDisable = [];

				for (c = 0; c < this.m_children.length; c += 1) {
					if (this.m_children[c].getName() === inChildName) {
						foundNode = this.m_children[c];
					} else if (this.m_children[c].getVisibleEnabled()) {
						nodesToDisable.push(this.m_children[c]);
					}
				}

				if (foundNode && !foundNode.getVisibleEnabled()) {
					foundNode.setVisible(true);
					for (c = 0; c < nodesToDisable.length; c += 1) {
						nodesToDisable[c].setVisible(false);
					}
				}
			},

			clone : function (clone_children, other) {
				var i, ci,
					result = other;

				if (result) {
					// init
					Container.call(result);
				} else {
					// alloc and init
					result = new Container();
				}

				// clone node state
				Node_clone.call(this, clone_children, result);

				utils.clone(true, result.privateWarper, this.privateWarper);

				// copy (by default) container children...
				if (clone_children === undefined || clone_children) {
					result.m_children = [];
					for (i = 0; i < this.m_children.length; i += 1) {
						ci = this.m_children[i];
						ci = ci.clone(clone_children);
						result.m_children[i] = ci;
						ci.setParent(result);
					}
				}

				return result;
			},

			setEnabledChildren : function (enabled) {
				var c;
				for (c = 0; c < this.m_children.length; c += 1) {
					this.m_children[c].setEnabled(enabled);
				}
			},

			// Warper
			setWarpDomain : function (type) {
				this.privateWarper.warpDomain = type;
			},

			getWarpDomain : function () {
				return this.privateWarper.warpDomain;
			},

			setWarpMeshExpansion : function (expansion) {
				this.privateWarper.warpMeshExpansion = expansion;
			},

			getWarpMeshExpansion : function () {
				return this.privateWarper.warpMeshExpansion;
			},

			setWarpHash : function (hash) {
				this.privateWarper.warpHash = hash;
			},

			getWarpHash : function () {
				return this.privateWarper.warpHash;
			},

			setWarpRest : function (aMatPuppet_HandleInitial0) {
				if (! aMatPuppet_HandleInitial0) { 
					// invalidate warper
					this.privateWarper.restMatParent_Puppet = null;
					this.privateWarper.aRestMatPuppet_Handle = [];
					this.privateWarper.aRestMatHandle_Puppet = [];
					return; 
				}

				// store initial/rest state...
				this.privateWarper.aRestMatPuppet_Handle = aMatPuppet_HandleInitial0;
				this.privateWarper.restMatParent_Puppet = this.getMatrix();
				this.privateWarper.aRestMatHandle_Puppet = lodash.map(this.privateWarper.aRestMatPuppet_Handle, function (m) { 
					return mat3.invert(m);
				});
			},

			warperSetsContainerMatrix : function () {
				return this.privateWarper.didSetContainerMatrix;
			},

			canWarp : function () {
				return this.privateWarper.canWarp;
			},

			shouldInitializeWarp : function () {
				return this.privateWarper.canInitialize();
			},

			/** 
			 * Warp container subtree.
			 * @param aMatContainer_Handle Array of affine transforms relative to local/container frame.
			 * @param aAutomationAttribute Array of logically ORed attributes indicating degrees of freedom in each transform.
			 * @return Boolean indicating whether warp was applied (true) or short-circuited (false) by updating container transform instead.
			 */
			warp : function (aMatContainer_Handle, aAutomationAttribute) {
				var warper = this.privateWarper;

				utils.assert(aMatContainer_Handle.length === aAutomationAttribute.length, "warp(): inconsistent arguments");

				if ( !warper.aRestMatPuppet_Handle ) return warper.didSetContainerMatrix; 

				var indexOfManual = 0,
					aMatManual = lodash.filter(aAutomationAttribute, function (attribute, index) {
					if (attribute < 3) {
						// partially manual
						indexOfManual = index;
						return true;
					} else {
						// fully automated
						return false;
					}
				});

				if (aMatManual.length <= 1) {
					// in case of a single transform, update local container matrix, instead of warping a mesh
					var matContainer_Handle = aMatContainer_Handle[indexOfManual],
						delta = mat3.multiply(matContainer_Handle, warper.aRestMatHandle_Puppet[indexOfManual]);
					this.setMatrix(mat3.multiply(warper.restMatParent_Puppet, delta));

					// propagate that transform to all handles
					for (var i = 0; i < aMatContainer_Handle.length; i++) {
						mat3.multiply(delta, warper.aRestMatPuppet_Handle[i], aMatContainer_Handle[i]);
					}

					// container used the local container matrix
					warper.didSetContainerMatrix = true;

				} else {
					// otherwise, warp using specified handles
					this.setMatrix(warper.restMatParent_Puppet); // remove a side-effect of the above special case

					if (warper.canWarp) {
						warper.cpp.warp(aMatContainer_Handle, aAutomationAttribute);
						this.callChangeNotifiers("warpChanged");
					}

					// did not use local container matrix
					warper.didSetContainerMatrix = false;
				}

				return warper.didSetContainerMatrix;
			},

/* TODO: uncomment, test, and use
			calcMeshLocation : function (locationSpace) {
				utils.assert(this.getMeshGeometry, "calcMeshLocation(): mesh not defined.");

				var i, candidateTriangle, 
					theTriangle = null, 
					theLocation = [],
					points = this.getMeshGeometry(),
					triangles = this.getMeshTopology();

				for (i = 0; i < triangles.length; i += 3) {
					candidateTriangle = triangles.slice(i, i+3);
					calcBarycentricLocation(points, candidateTriangle, locationSpace, theLocation);
					if (isBarycentricLocationInsideTriangle(theLocation)) {
						theTriangle = candidateTriangle;
						break;
					}
				}

				return {
					triangle : theTriangle,
					location : theLocation 
				};
			},

			calcWarpAtMeshLocation : function (triangle, location) {
				var weightsMesh, pointsMesh, pointsTriangle,
					cData = this.pContainer,
					handles = cData.handles,
					pointsHandle = this.getRestLocations();

				utils.assert(cData.handles, "calcWarpAtPoint(): warp not defined.");
				utils.assert(this.getMeshWeights, "calcWarpAtPoint(): weights not defined.");

				pointsMesh = this.getMeshGeometry();
				weightsMesh = this.getMeshWeights();

				// evaluate warp
				pointsTriangle = lodash.map(triangle, function (vi) {
					var pointIndex = 2*vi,
						pi = pointsMesh.slice(pointIndex, pointIndex+2);

					return lodash.reduce(handles, 
						function (result, hj, j) {
							var mat = hj.getMatrixRelativeTo("kPuppetHandle"),
								wij = weightsMesh[vi*handles.length + j],
								pij = vec2.subtract(pi, pointsHandle[j], vec2());
							return vec2.axpy(wij, pij.transformAffine(mat), result, result);
						}, 
						vec2([0.0, 0.0]));
				});

				// evalyate barycentric combination
				return lodash.reduce(pointsTriangle, 
					function (result, pi, i) {
						return vec2.axpy(location[i], pi, result, result);
					}, 
					vec2([0.0, 0.0]));
			}
*/			
			
			/**
			 * Called by Zoot's native stage.
			 * @param warper Component in charge of warper computation.
			 */
			addWarperComponent : function (warper) {
				this.privateWarper.cpp = warper;
			},

			initWarp : function () {
				var warper = this.privateWarper;
				if (warper.canInitialize()) {
					try {
						warper.cpp.init(warper.warpHash, warper.getRestLocations(), warper.warpDomain, warper.warpMeshExpansion);
						warper.canWarp = true;
					} catch(e) {
						warper.canWarp = false;
					}
				}
			}

		});


	return Container;
});
