/*global define */
/*jslint white: true */

/*
	CommandPlayer:

	This class is used to enumerate commands from an object.
	
	Concept:
		1. object has a getCommands function that returns an array.
		2. each command within the array has a cmd members that's a string
			and a "parameters" member.
*/
define(function () {
	'use strict';

	return function CommandPlayer(inObject) {
		var that = this, m_obj = inObject;

		that.play = function (outPlayer) {
			var i, playerFunc, cmds = m_obj.getCommands();

			for (i = 0; i < cmds.length; i += 1) {
				playerFunc = outPlayer[cmds[i].cmdName];

				if (typeof playerFunc === 'function') {
					playerFunc(cmds[i].parameters);
				}
			}
		};

		return that;
	};
});
