/*global define */
/*jslint white: true */

/*
	Color:

	This stores Color information..
*/

define(["src/utils"],
function (utils) {
	'use strict';

	return function Color(r, g, b, a) {
		var that = this, printColorValue, m_prints;

		that.r = r; // 0-1
		that.g = g; // 0-1
		that.b = b; // 0-1
		that.a = a || 1.0;   // 0-1

		that.clone = function () {
			// Copy
			var newColor = utils.clone(false, {}, this);
			return newColor;
		};

		printColorValue = function (inObj, inColorName, inColor) {
			if (m_prints !== "") {
				m_prints += ",";
			}
			if (inObj[inColorName] !== undefined) {
				m_prints += inColorName + ":" + inObj[inColorName];
			}
			return m_prints;
		};

		that.print = function () {
			m_prints = "";

			printColorValue(this, "r", this);
			printColorValue(this, "g", this);
			printColorValue(this, "b", this);
			printColorValue(this, "a", this);

			return m_prints;
		};

		return that;
	};
});
