/*global define, nmlImpl */
/*jslint white: true */

/*
	Builder:

	This class provides the model creation tools need to build your puppet or audio elements.
*/

define([	"src/build/Container",	"src/build/Image",		"src/build/Graphics",		"src/build/AudioContainer",		"src/build/AudioClip",		"src/build/AudioMediaClip",
			"src/build/Scene",		"src/build/Track",		"src/build/TrackItem",		"src/build/TrackItemSource",	"src/build/Handle"],
function(	Container,				Image,					Graphics,					AudioContainer,					AudioClip,					AudioMediaClip,
			Scene,					Track,					TrackItem,					TrackItemSource,				Handle) {
	'use strict';

	return function Builder() {
		var that = this;

		that.newHandle = function (inOptions0) {
			return new Handle(inOptions0);
		};
		
		that.newContainer = function (inName) {
			return new Container(inName);
		};

		that.newImage = function (image_uri, inName) {
			return new Image(image_uri, inName);
		};

		that.newGraphics = function (inName) {
			return new Graphics(inName);
		};

		that.newAudioContainer = function (inName, inPlayASAP) {
			return new AudioContainer(inName, inPlayASAP);
		};

		that.newAudioMediaClip = function (inName, inURI, inPlayASAP) {
			return new AudioMediaClip(inName, inURI, inPlayASAP);
		};

		that.newScene = function (inFrameRate, inPixWidth, inPixHeight) {
			return new Scene(inFrameRate, inPixWidth, inPixHeight);
		};

		that.newTrack = function (inTrackName) {
			return new Track(inTrackName);
		};

		that.newTrackItem = function (inTrackSourcePPath) {
			return new TrackItem(inTrackSourcePPath);
		};
		
		that.newTrackItemSource = function (inPPathString, inClassInstance, inJsonPath) {
			return new TrackItemSource(inPPathString, inClassInstance, inJsonPath);
		};

		that.newTimeGraph = function (inCurves0) {
			return nmlImpl.newTimeGraph(inCurves0);
		};

		that.newSpatialTimeGraph = function (inCurves0) {
			return nmlImpl.newSpatialTimeGraph(inCurves0);
		};
		
		return that;
	};
});