define(["lodash", "src/utils"],
function (lodash, utils) {
	"use strict";

	var arrayPush = Array.prototype.push;

	function fnConstant (value) {
		return function () { return value; };
	}


	function gatherLayerTree (self, layerRoot) {
		var aLayer = [],
			aPuppet = [],
			aParentRef = [];


		var puppet,
			layer = layerRoot,
			parentRef = null,
			stackLayer = [],
			stackRef = [];

		while (layer) {
			puppet = layer.getPuppet();

			if (puppet) {
				aLayer.push(layer);
				aPuppet.push(puppet);
				parentRef = aParentRef.push(parentRef) - 1;

				var kids = puppet.getLayers().slice(0);
				layer = kids.shift();
				arrayPush.apply(stackLayer, kids.reverse());
				arrayPush.apply(stackRef, kids.map(fnConstant(parentRef)));
			} else {
				layer = stackLayer.pop();
				parentRef = stackRef.pop();
			}
		}

		self.aLayer = aLayer;
		self.aPuppet = aPuppet;
		self.aParentRef = aParentRef;
	}

	function getMatrixWarper_Tag (warper, layer) {
		/*jshint validthis: true*/
		var handleRef = warper.getAttachToTagIndex(layer),
			handleRoot = warper.getHandleTreeRoot(),
			aHandle = warper.getLocalHandleTreeArray(handleRoot).value,
			handle = aHandle[handleRef];

		return handle.getMatrixRelativeTo(null);
	}

	function BakedLayer (layer) {
		gatherLayerTree(this, layer);
	}

	utils.mixin(BakedLayer, {
		warp : function () {
			var layer, puppet, layerParent, puppetParent,
				aLayer = this.aLayer,
				aPuppet = this.aPuppet,
				aParentRef = this.aParentRef,
				ref = -1,
				length = this.aLayer.length;

			while (++ref < length) {
				layer = aLayer[ref];
				puppet = aPuppet[ref];
				layerParent = aLayer[aParentRef[ref]];
				puppetParent = aPuppet[aParentRef[ref]];

				var cLayerAttacher = layer.getDisplayContainer();
				if (layerParent) {
					if (layerParent.didWarp()) {
						// HACK: make it general with real warper instead of puppetParent
						// cLayerAttacher.setMatrix(getMatrixWarper_Tag(puppetParent, layer));
					}
				}

				var cWarper = layer.getWarperContainer();
				if (cWarper) {
					// warp and scatter to subpuppets that warp together
					// var	aMatSource_Leaf = puppet.gatherHandleLeafMatrixArray(),
					// 	aAutoAttributes = puppet.getHandleLeafAutoAttributes();

					// cWarper.warp(aMatSource_Leaf, aAutoAttributes);
					// puppet.scatterHandleLeafMatrixArray(aMatSource_Leaf);
				}
			}
		}

	});

	return BakedLayer;
});
