/*global define */
/*jslint white: true */

/*
	AudioMediaClip:

	This object provides a mixin for each audio media clip.
*/

define  ([  "src/build/AudioClip",	"src/utils",    "src/build/treeLeaf",	"src/build/TimeItem"],
function(   AudioClip,              utils,			treeLeaf,				TimeItem) {
	'use strict';

	var AudioClip_clone = AudioClip.prototype.clone;

	function AudioMediaClip(inName, inMediaURI, inPlayASAP) {
		this.AudioClip("AudioMediaClip", inName, inPlayASAP);

		// do not modify these private members directly or notifiers won't be called correctly
		this.pMediaClip = { 
			mediaURI : inMediaURI
		};
	}

	utils.mixin(AudioMediaClip, 
		AudioClip,
		{
			// const return value
			getMediaURI : function () {
				return this.pMediaClip.mediaURI;
			},

			clone : function (clone_children, other) {
				var i, ci, 
					result = other;

				if (result) {
					// init
					AudioMediaClip.call(result);
				} else {
					// alloc and init
					result = new AudioMediaClip();
				}

				utils.clone(false, result.pMediaClip, this.pMediaClip);

				// clone node state
					AudioClip_clone.call(this, clone_children, result);

				return result;
			}
		}
	);

	return AudioMediaClip;
});
