/*global define, console, require */
/*jslint white: true */

define(["jquery-require"],
function (jQuery) {
    'use strict';

	// this used to make a hierarchy for each group, but now groups are UI-only and
	//	the params are a flat map (though still inheriting trackitem->boundbehavior->projectbehavior)
    function makeSkeletonParams(idParams) {
        var aThisGroup = {}, key = false;
        aThisGroup = Object.create(idParams); // group->group inheritance, not needed @@@?

        for (key in idParams) {
            if (idParams.hasOwnProperty(key)) {
                aThisGroup[key] = Object.create(idParams[key]); // param->param inheritance
            }
        }
        return aThisGroup;
    }

	// adds a level of indirection to match the normal params[id]->param.value structure
	//	see definition of _paramBag in TrackItemBehavior.lua if we want to fix this
	//	to be regular (e.g. for allowing custom name, min, max, etc. at the track item level)
    function prepParamBagForMergingIntoSkeleton(idParams) {
        var aThisGroup = {}, key;

        for (key in idParams) {
            if (idParams.hasOwnProperty(key)) {
                aThisGroup[key] = { value: idParams[key] };
            }
        }
        return aThisGroup;
    }

    function mergeParams(srcParams, inEventGraphKey, inAddParameterIdToEvenGraphKey, dstParams) {
        var key, key2, v, v2;
        for (key in srcParams) {
            if (srcParams.hasOwnProperty(key)) {
                v = srcParams[key];

				for (key2 in v) {
					if (v.hasOwnProperty(key2)) {
						// If we are overriding the value, assume that when a less important eventgraph
						// value is published, it is also published with an override if need be.
						v2 = v[key2];
						dstParams[key][key2] = v2;
					}
				}
				if (inEventGraphKey !== undefined) {
					if (dstParams[key].eventGraphValueKeyArray === undefined) {
						dstParams[key].eventGraphValueKeyArray = [];
					}
					dstParams[key].eventGraphValueKeyArray.push(inAddParameterIdToEvenGraphKey(inEventGraphKey, key));
				}
            }
        }
		if (inEventGraphKey !== undefined) {
			for (key in dstParams) {
				if (dstParams.hasOwnProperty(key)) {
					if (dstParams[key].eventGraphValueKeyArray === undefined) {
						dstParams[key].eventGraphValueKeyArray = [];
					}
					dstParams[key].eventGraphValueKeyArray.push(inAddParameterIdToEvenGraphKey(inEventGraphKey, key));
				}
			}
		}
    }

	// used to convert the full deep param array (now only sent for the project behavior level) into
	//	a flat paramID-indexed form; also copies dephaults into value to match the way the code used to
	//	work in Lua
	function arrayParamsToIDParams(arrayParam, idParams0) {
		var i, d, param, idParams = idParams0 || {};
		for (i = 0; i < arrayParam.length; i += 1) {
			param = arrayParam[i];
			
			if (param.value === undefined) {
				d = param.dephault;
				if (d !== undefined && typeof(d) !== "object") { // e.g. groups have no default; layer params have an object dephault
					param.value = d;
				}
			}
			if (param.groupChildren) {
				// we could in the future add groups into this map, but for now considering them to be Lua UI-usage only
				arrayParamsToIDParams(param.groupChildren, idParams);
			} else {
				idParams[param.id] = param;
			}
		}
		return idParams;
	}

    return {
        makeSkeletonParams: makeSkeletonParams,
        prepParamBagForMergingIntoSkeleton: prepParamBagForMergingIntoSkeleton,
        mergeParams: mergeParams,
        arrayParamsToIDParams: arrayParamsToIDParams
    };
});
