/*global define, require */
/*jslint white: true */

/*
	Implements Squiggle vision.
*/

define(["src/build/Graphics", "src/build/Container", "src/animate/randomizePath"],
function (Graphics, Container, randomizePath) {
	'use strict';

	// inPathNames named like "Container2/Container3/Path Name", or "Container2/Container3/...", relative to inContainer.  If undefined,
	// all NAMED paths are squiggled.
	return function Squiggle(inContainer, inFrameDuration, inNumFrames, inSeed) {
		var that = this;

		inSeed = inSeed || 0;
		inNumFrames = inNumFrames || 6;
		inFrameDuration = inFrameDuration || 0.2;

		that.paths = [];
		that.lastFrameChangeTime = undefined;
		that.frameIndex = 0;

		function getSeedValue(inFrameIndex, inPathIndex, inSeed)
		{
			return (inFrameIndex + 1) * 12345 + (inPathIndex + 1) * 67890 + inSeed;
		}

		function squigglePath(ioGraphic, inPathName, inOriginalPath, inMaxPixelDistance, inFrameIndex, inPathIndex, inSeed)
		{
			ioGraphic.setPath(inPathName, randomizePath(inOriginalPath, inMaxPixelDistance, getSeedValue(inFrameIndex, inPathIndex, inSeed)));
		}
	
		that.apply = function (inTime, inMaxPixelDistance) {
			var frameChange, frameUpdate = (this.lastFrameChangeTime === undefined),
				pathName, i, g, seed, originalPath, cmds, frameIndex, pathIdx = 0, dt;
			
			inMaxPixelDistance = (inMaxPixelDistance === undefined) ? 1 : inMaxPixelDistance;

			this.lastFrameChangeTime = this.lastFrameChangeTime || inTime;
			dt = (inTime - this.lastFrameChangeTime);
			
			frameChange = dt < 0 || dt > inFrameDuration;
			if (frameChange) {
				frameUpdate = true;
				this.lastFrameChangeTime = inTime;
				this.frameIndex = (this.frameIndex + 1) % inNumFrames;
			}
			if (frameUpdate) {
				frameIndex = this.frameIndex;
				inContainer.breadthFirstEach(function (g) {
					if (g.constructor === Graphics && g.isVisible()) {
						cmds = g.getCommands();

						// Replace all paths with this name.
						for (i = 0; i < cmds.length; i += 1) {
							pathName = cmds[i].parameters.path.getName();
							if (pathName) {
								// attaching the originalPath to the graphic by name.
								if (!g.pSquiggleData) {
									g.pSquiggleData = [];
								}
								if (!g.pSquiggleData[pathName]) {
									originalPath = g.forEachPathNamed(pathName, undefined, true);
									g.pSquiggleData[pathName] = originalPath;
								} else {
									originalPath = g.pSquiggleData[pathName];
								}
								pathIdx += 1;
								squigglePath(g, pathName, originalPath, inMaxPixelDistance, frameIndex, pathIdx, inSeed);
							}
						}
					}
				});
			}
		};

		return that;
	};
});
