/*global require, runScript, __bootStrapPath, __compiledScene, parseJSON*/
/*jshint unused: vars */


runScript("../../../../shared/adobe/apd/nml/nml_include.js");

(function () {
	"use strict";

	require(["lib/Zoot", "lib/ReplacerUtilities", "lodash", "src/build/ZoneProfiler"],
	function (Z, ReplacerUtilities, lodash, ZoneProfiler) {
		var dependencies = [],
			// parsing twice, TODO
			rootScene,
			stage,
			sceneJSON = {},
			doAnimate,
			builder = new Z.Builder(),
			CreateFactoryObjects,
			firstAnimateCalled = false,
			initAnimalTimeItem = function(inData, ioObj) { 
				ioObj.setTrimInTime(inData._trimInTime);
				ioObj.setTrimOutTime(inData._trimOutTime);
				ioObj.setDuration(inData._durationTime);
				ioObj.setParentOffsetTime(inData._parentOffsetTime);
			},
			initBehaviorBag = function(ioPuppetInstance) {

				function initBBag(ioPuppetInstance) {
					var	bi, key, bbag = ioPuppetInstance._behaviorBag, childInstances, egPile, egPileItem, i;
					for (key in bbag) {
						if (bbag.hasOwnProperty(key)) {
							bi = bbag[key];
							egPile = bi._egPile;
							for (i = 0; i < egPile._aPileItems.length; i += 1) {
								egPileItem = new CreateFactoryObjects(egPile._aPileItems[i]);
								initAnimalTimeItem(egPile._aPileItems[i]._timeItem, egPileItem);
								egPile._aPileItems[i] = egPileItem;
							}
							
						}
					}
					if (ioPuppetInstance._children) {
						childInstances = ioPuppetInstance._children;
						for (key in childInstances) {
							if (childInstances.hasOwnProperty(key)) {
								initBBag(childInstances[key]);
							}
						}
					}
				}
				
				initBBag(ioPuppetInstance);
			},
			factory = {
				Scene: function(inData) {
					var s = new Z.Scene(inData._framerate, inData._pixWidth, inData._pixHeight), t, tracks, track;

					s.setSimulationRateFactor(inData._simulationRateFactor);

					tracks  = inData._aTracks;
					for (t = 0; t < tracks.length; t += 1) {
						track = new CreateFactoryObjects(tracks[t]);
						s.addChild(track);
					}

					s.setTrackItemSource(new CreateFactoryObjects(inData.pPath));

					return s;
				},
				PPath: function(inData) { 
					return new Z.TrackItemSource(inData.p, inData.classInstance, inData.jsonPath);
				},
				EventGraphPileItem_: function(inData) {
					return new Z.EventGraphPileItem(inData._bEnabled, inData._bSolo, inData._boundBehaviorID, inData._boundInstanceID, 
														inData._paramId, inData.filePath);
				},
				TrackItem: function(inData) {
					var ti, trackSource;
					
					trackSource = new CreateFactoryObjects(inData._trackSource);

					ti = new Z.TrackItem(trackSource, inData._rootTrackItemPuppet);
					initAnimalTimeItem(inData._timeItem, ti);

					initBehaviorBag(ti.getInstanceInfo());
					
					return ti;
				},
				Track: function(inData) { 
					var t = new Z.Track(inData._name), tItem, trackItems, ti;

					t.setAudibleEnabled(inData._audible);
					t.setVisibleEnabled(inData._visible);
					t.setArmedForRecord(inData._bArmedForRecord);

					trackItems  = inData._aTrackItems;
					for (ti=0; ti < trackItems.length; ti += 1) {
						tItem = new CreateFactoryObjects(trackItems[ti]);
						t.addChild(tItem);
					}

					return t;
				}
			};

		CreateFactoryObjects = function (inData) {
			if (inData.factoryKey) {
				if (factory[inData.factoryKey]) {
					return factory[inData.factoryKey](inData);
				}
			}
			return undefined;
		};

		function isParamArmedForRecord (inBehavior, inParamId)
		{
			var armedForRecordOnB = inBehavior.behaviorBag._paramArmedBag[inParamId];

			if (armedForRecordOnB === undefined) {
				armedForRecordOnB = inBehavior.params[inParamId].defaultArmedForRecordOn || false;
			}
			return armedForRecordOnB;
		}

		function getLayerMatrixRelativeToScene (layer, result0) {
			/*jshint validthis: true*/ // Use call() for reuse in mixins.
			var result = result0 || [],
				cLayer = layer.getDisplayContainer(),
				// TODO: should be relative to scene but we don't have that container yet
				// cScene = this.scene_.getDisplayContainer(),
				// instead will use whatever is at the root
				cScene = null;

			if (cLayer) return cLayer.getMatrixRelativeTo(cScene, result);

			return Z.Mat3.identity(result);
		}

		function getHandleMatrixRelativeToScene (handle, result0) {
			/*jshint validthis: true*/ // Use call() to reuse in mixins.
			var warper = handle.getWarperLayer(),
				matScene_Warper = this.getLayerMatrixRelativeToScene(warper),
				matWarper_Handle = warper.getHandleMatrix(handle);

			return Z.Mat3.multiply(matScene_Warper, matWarper_Handle, result0);
		}

			
		function BehaviorParamBlock (inScene, inBehavior, inBehaviorInstanceId, inEventGraph, inTimeStack, inGlobalRehearseTime, inRehearseTime, inBehaviorLiveB, inStagePuppet, inEventGraphEvaluators) {
			var timeSpan = inTimeStack.getLocalTimeSpan();
			this.scene_ = inScene;
			this.behavior = inBehavior;
			this.behaviorInstanceId = inBehaviorInstanceId;
			this.eventGraph = inEventGraph;
			this.timeStack = inTimeStack;
			this.t = timeSpan.t;
			this.dt = timeSpan.dt;
			this.globalRehearseTime = inGlobalRehearseTime;
			this.rehearseTime = inRehearseTime;
			this.behaviorLiveB = inBehaviorLiveB;
			this.stagePuppet = inStagePuppet;
			this.stageLayer = inStagePuppet.getParentLayer().getSdkLayer();	// layer whose source is the stage puppet -- for starting recursive walks
			this.eventGraphEvaluators = inEventGraphEvaluators;
		}

		// methods on the param block
		Z.utils.mixin(BehaviorParamBlock, {
			
			getParamData : function (inId) {
				var paramParent = this.behavior.pGetParams(), p;
				
				p = paramParent[inId];

				if (p) {
					return p;
				} else {
					throw new Error("Behavior " + this.behavior.behaviorPPath + " missing parameter ID '" + inId + "'");
				}
			},
			
			getEvaulationTime : function (inGraphEvaluator, inId, inLocalOrLiveOnlyB) {
				var globalEvalB = inGraphEvaluator.evaluatesAtGlobalTime();
				var armedForRecordOnB = isParamArmedForRecord(this.behavior, inId);

				if (!inLocalOrLiveOnlyB || (!globalEvalB || (this.behaviorLiveB && armedForRecordOnB))) {
					return inGraphEvaluator.getTimeSpan(this.timeStack).t + 
							(globalEvalB ? this.globalRehearseTime : (armedForRecordOnB ? this.rehearseTime : 0.0));
				
				}
				return undefined;
			},

			getGraphEvaluator : function (inId) {
				if (!this.eventGraphEvaluators[inId]) {
					this.eventGraphEvaluators[inId] = this.eventGraph.getEvaulator(this.behaviorInstanceId);
				}

				return this.eventGraphEvaluators[inId];
			},

			getParam : function (inId) {
				var p = this.getParamData(inId), i, egk, v;
			
				var graphEvaluator = this.getGraphEvaluator(inId, false), t;
				t = this.getEvaulationTime(graphEvaluator, inId);
				// check in order from specific to general -- this is needed for param inheritance
				if (p.eventGraphValueKeyArray) {
					for (i = p.eventGraphValueKeyArray.length-1; i >= 0; i -= 1) {
						egk = p.eventGraphValueKeyArray[i];
						if (egk) {
							v = graphEvaluator.getValue("Param" + egk, t);
							if (v !== undefined) {
								return v;
							}
						}
					}
				}
				return p.value;
			},

			getParamEventEvaluator: function (inId, inEventName) {
				var paramParent = this.behavior.pGetParams(), p, j, foundParamKeyB = false;
				
				p = paramParent[inId];
				
				Z.utils.assert(p.type === "eventGraphInput");
				
				// Create Array ID to Index table
				
				for (j = 0; j < p.inputKeysArray.length; j += 1) {
					if (inEventName.indexOf(p.inputKeysArray[j]) === 0) {
						foundParamKeyB = true;
						break;
					}
				}
				
				Z.utils.assert(foundParamKeyB, inEventName + " not found in inputKeysArray when calling getParamEventValue");

				return this.getGraphEvaluator(inId);
			},
			
			isParamEventLive : function (inId) {
				var armedForRecordOnB = isParamArmedForRecord(this.behavior, inId);

				return (this.behaviorLiveB && armedForRecordOnB);
			},

			getParamEventValue: function (inId, inEventName) {
				var graphEvaluator = this.getParamEventEvaluator(inId, inEventName), t;
				t = this.getEvaulationTime(graphEvaluator, inId, true);
				
				if (t !== undefined) {
					return graphEvaluator.getValue(inEventName, t);
				}
				return undefined;
			},
			
			setInputParamUsedDuringRecording: function (inId) 
			{
				stage.setInputParamUsedDuringRecording(this.behaviorInstanceId, inId);
			},

			getLayerMatrixRelativeToScene : function (layer, result0) {
				return getLayerMatrixRelativeToScene.call(this, layer, result0);
			},

			getHandleMatrixRelativeToScene : function (handle, result0) {
				return getHandleMatrixRelativeToScene.call(this, handle, result0);
			}
		});


		function CreateStageBehaviorParamBlock (inBehavior, inBackstageBehavior, inStagePuppet)
		{
			this.behavior = inBehavior;
			// this.backstageBehavior = inBackstageBehavior; no one needs this yet, let's not send it
			this.stagePuppet = inStagePuppet;
			this.stageLayer = inStagePuppet.getParentLayer().getSdkLayer();
		}

		// methods on the param block
		Z.utils.mixin(CreateStageBehaviorParamBlock, {
		
		/* now disabled in favor of doing this on the Lua side, but in the future when we start doing more advanced
			dynamic puppet creation & rigging on the stage itself, this may be useful for late-binding
			the layer params

			// returns (possibly empty) list of layers that match the pseudo-Xpath, starting at the layer whose source is the puppet that owns this behavior
			resolveLayerParam: function (dephault, inMaxCount0)
			{
				var xpath = dephault.match, regexp, caseInsensitive = "i", aRoots = [], aStarts, aResults = [];
				
				aRoots[0] = this.stagePuppet.parentLayer; // only Layers jam this field in their source
				
				if (aRoots[0] === undefined) {
					aRoots[0] = this.stagePuppet.getParent(); // TrackItem in this case
				}
				
				if (dephault.startMatchingAtParam) {
					// NOTE: NOT YET TESTED
					aStarts = this.getStaticParam(dephault.startMatchingAtParam); // public API
					// convert from sdk to our notion of layer; note: if other param has no matches, we will also have none
					aRoots = lodash.map(aStarts, function (lay) {
						return lay.privateLayer;
					});
				}

				// so far we just support dot and "anywhere" notation
				if (xpath === ".") {
					aResults = aRoots;
				} else {
					if (xpath.indexOf("//") === 0) {
						// TODO: this is supposed to be full-name-match only, but currently allows arbitrary text at the
						//	end of the name, until we can strip the (b!) notation into an attribute

						// TODO: use stringToRegExp() to escape metachars
						regexp = new RegExp("^" + xpath.substr(2), caseInsensitive);
					} else {
						throw new Error("Unsupported behavior layer param syntax: " + xpath);
					}

					aRoots.forEach(function (rootLayer) {
						rootLayer.breadthFirstEachLayer(function (layer) {
							if (regexp.test(layer.getName()) || regexp.test(layer.getSource().getName())) {
								aResults.push(layer);
								if (inMaxCount0 && aResults.length >= inMaxCount0) {
									return false; // ends recursion
								}
							}
						});
					});
				}
				
				// convert from internal Layer/TrackItem to SdkLayer
				return lodash.map(aResults, function (lay) {
					return lay.getSdkLayer();
				});
			},
		*/

			getStaticParam : function (inId) {	// same params as getParam now that getParam doesn't take a time -- but needs factoring, and
												//	worth noting that the results from this version can be cached forever, not true during onAnimate
				var params = this.behavior.pGetParams(), p, v;
				
				p = params[inId];
				
				if (p) {
					v = p.value;
					if (v === undefined) {
						throw new Error("Behavior " + this.behavior.behaviorPPath + " missing value for static parameter ID '" + inId + "'");
					} else if (typeof(v) === "object") {
						return lodash.clone(v); // can't cloneDeep because it would destroy the prototypes & identity of the Layers inside,
												//	so we just clone the outer shell and ask that behaviors treat it as read-only anyway.
												//	we could get one more layer of safety by cloning the dagPath (which is currently just a plain
												//	array), but that might change in the future. So we just clone the outer array. If we start
												//	having a .value datatype that's a complex object, we'll need more code here to distinguish.
					} else {
						return v;
					}
				} else {
					throw new Error("Behavior " + this.behavior.behaviorPPath + " missing static parameter ID '" + inId + "'");
				}
			},

			getLayerMatrixRelativeToScene : function (layer, result0) {
				return getLayerMatrixRelativeToScene.call(this, layer, result0);
			},

			getHandleMatrixRelativeToScene : function (handle, result0) {
				return getHandleMatrixRelativeToScene.call(this, handle, result0);
			}

		});
		
		
		function log (str)
		{
			// console.log(str); // uncomment to turn on a bunch of logging in this file
		}

		function failFn()
		{
			console.log("failed to parse behavior/parameters JSON dictionary");
		}

		function stripExtension (stringIn)
		{
			return stringIn.substr(0, stringIn.lastIndexOf(".")) || stringIn;
		}

		/*function getCPathComponentString (inCPath)
		{
			var index = inCPath.indexOf(":");

			if (index === -1) {
				throw new SyntaxError("Invalid CPath");
			}

			return inCPath.substr(index+1);
		}*/
		
		function addParameterIdToCPath(inEventGraphKey, inId) {
			if (inEventGraphKey === undefined) {
				throw new SyntaxError("Invalid parameter id for CPath");
			}
			return inEventGraphKey + ":_parameter" + ":" + inId;
		}
		
		function addParameterIdToTrackItemBehavior(inBehaviorInstanceId) {
			return function(inEventGraphKey, inId) {
				if (inEventGraphKey === undefined) {
					throw new SyntaxError("Invalid parameter id for CPath");
				}
				var result = inEventGraphKey + inId;
				if (inBehaviorInstanceId) {
					result = result + "/" + inBehaviorInstanceId;
				}
				return result;
			};
		}

		function parseAudioFile (audioFilePath, trackCPath)
		{
			var audioFile = {}, audioFileJSON;

			parseJSON(audioFilePath, function successFn(inData) { audioFileJSON = inData; }, failFn);

			audioFile.filePath = audioFileJSON.filePath;

			return audioFile;
		}
				
		
		function resolveDagPathToSdkLayer (stagePuppet, dagPath)
		{
			var pup = stagePuppet, layer = stagePuppet.getParentLayer();
			
			dagPath.forEach(function (layerID) {
				layer = pup.getLayerByID(layerID);
				pup = layer.getPuppet(); // i.e. the source of the layer if a puppet, else null
			});
				
			return layer.getSdkLayer();
		}
		
		
		function resolveStageBehaviorLayerAndHandleParameters (stagePuppet, stageBehavior)
		{
			// for each layer parameter, convert the array of dagPaths into an array of layers. 
			//	Because of getResolvedParams() on the lua side we can count on all layer params
			//	existing at the bound behavior level (no inheritance from project, and no overriding
			//	by the track item), so no need to loop over the inherited set of all params.
			var params = stageBehavior.pGetParams(), param;
			
			function resolveDagPath(dagPath) { // define closure outside of loop
				return resolveDagPathToSdkLayer(stagePuppet, dagPath);
			}
			
			function resolveHandle(pair) {
				var puppet, handle,
					match = pair.sHandleName,
					layer = resolveDagPathToSdkLayer(stagePuppet, pair.dagPath);
				
				puppet = layer.getPuppet();
				
				// lookup handle by name
				// TODO: update to operate on Layer instead of Puppet.  as is, it will not resolve handle in subpuppets that warp with parent.
				puppet.getHandleTreeRoot().preOrderEach(function (h) { // order here shouldn't matter, name is unique
					if (h.getName() === match) {
						handle = h;
						return false; // break iteration
					}
				});

				return handle;
			}
			
			for (var id in params) {
				if (params.hasOwnProperty(id)) {
					param = params[id];
					if (param.type === "layer") {
						// array of dagPaths -> array of SdkLayers
						param.value = lodash.map(param.value, resolveDagPath);
					} else if (param.type === "handle") {
						// array of { dagPath, sHandleName } -> array of Handles
						param.value = lodash.map(param.value, resolveHandle);
					}
				}
			}
		}



		function parseScene (scenePath, trackCPath, trackItem0)
		{
			var scene, sceneId, parseChildrenFunc, sceneData, isRootSceneB = false;

			parseJSON(scenePath, function successFn(inData) { sceneJSON = inData; }, failFn);

			scene = new CreateFactoryObjects(sceneJSON);
			
			if (trackItem0) {
				scene.setParent(trackItem0);
			} else {
				isRootSceneB = true;
			}

			if (trackCPath === undefined) {
				trackCPath = scene.getTrackItemSource().getPPathString();
			}

			log("sceneJSON factoryKey = " + sceneJSON.factoryKey);
			log("scene frame rate = " + scene.getFrameRate() + " FPS");
			log("scene simulation frame rate = " + scene.getFrameRate() * scene.getSimulationRateFactor() + " FPS");
			log("scene trackItemSource String = " + scene.getTrackItemSource().getPPathString());

			if (stage === undefined) {
				sceneId = scene.getTrackItemSource().getPPathString();
				
				stage = Z.nml.getStage(sceneId);
				
				sceneData = {	frameRate				:	scene.getFrameRate(),
								pixWidth				:	scene.getPixelWidth(), 
								pixHeight				:	scene.getPixelHeight(),
								simulationRateFactor	:	scene.getSimulationRateFactor(),
								curtainsOpen			:	false,
								bootStrapPath			:	__bootStrapPath};

				if (!stage) {
					stage = Z.nml.newStage(sceneId, sceneData);
					stage.setCurtainsOpen(false);
					Z.nml.initEventGraph(sceneId, stage);
				} else {
					stage.setCurtainsOpen(false);
					stage.reboot(sceneData);
				}
			}

			function prepPuppetBehaviors (puppet, trackCPath) 
			{   
				var d, additionalDeps = dependencies.slice(), behaviorStart = dependencies.length, aBehaviors;

				aBehaviors = puppet.getBehaviors();

				log(JSON.stringify(aBehaviors));
				for (d = 0 ; d < aBehaviors.length; d += 1) {
					additionalDeps.push(stripExtension(aBehaviors[d].behaviorRef));
				}

				require(additionalDeps, function () {

					function prepBehaviors(varArgs)
					{
						log("prepBehaviors");

						var behaviorJSModules = varArgs.slice(behaviorStart),
							numBehaviors = behaviorJSModules.length,
							backstageBehaviorsArray = [],
							j=0,
							backstageBehavior = {},
							projBehavior = {},
							stageBehavior = {},
							args, stageBehaviorsArray = [],
							dispatchProperty, dispatchProperties = [];


						log("scene = " + scene);

						// base params
						for (j = 0; j < numBehaviors; j += 1) {
							projBehavior = new Z.AbstractBehavior("projectBehavior");
							backstageBehavior = new Z.AbstractBehavior("backstageBehavior");

							projBehavior.pSetParams(Z.behaviorUtils.arrayParamsToIDParams(aBehaviors[j].aProjectBehaviorParams)); // full set

							// Don't pass an event graph key, not updating based on project behavior changes anymore.
							backstageBehavior.pSetParams(Z.behaviorUtils.makeSkeletonParams(projBehavior.pGetParams()));	// sparse
							Z.behaviorUtils.mergeParams(aBehaviors[j].puppetBehaviorParams, aBehaviors[j].puppetBehaviorCPath, addParameterIdToCPath, backstageBehavior.pGetParams());

							backstageBehaviorsArray.push(backstageBehavior);
						}


						for (j = 0; j < numBehaviors; j += 1) {
							log(JSON.stringify(backstageBehaviorsArray[j].pGetParams()));
						}

						for (j = 0; j < numBehaviors; j += 1) {
							var func = behaviorJSModules[j].onCreateBackStageBehavior;
							dispatchProperty = func ? func(backstageBehaviorsArray[j]) : false;
							dispatchProperty = dispatchProperty || { 
								order : 1.0,
								importance : 0.0
							};
							dispatchProperty.index = j;  // points to corresponding module/behavior
							dispatchProperties.push(dispatchProperty);
						}

						for (j = 0; j < numBehaviors; j += 1) {
							stageBehavior = new Z.AbstractBehavior("stageBehavior");

							stageBehavior.behaviorPPath = aBehaviors[j].behaviorPPath;
							stageBehavior.behaviorId = stageBehavior.behaviorPPath.substr(stageBehavior.behaviorPPath.lastIndexOf("/")+1) || stageBehavior.behaviorPPath;
							stageBehavior.behaviorArrayId = aBehaviors[j].behaviorArrayId;
							stageBehavior.puppetBehaviorCPath = aBehaviors[j].puppetBehaviorCPath;
							//stageBehavior.trackBehaviorCPath = trackCPath + ":" + getCPathComponentString(stageBehavior.puppetBehaviorCPath);
							stageBehavior.pSetParams(Z.behaviorUtils.makeSkeletonParams(backstageBehaviorsArray[j].pGetParams()));
							// TODO:  Need to merge these parameters and use the correct CPath for the eventGraphKey -jacquave
							
							resolveStageBehaviorLayerAndHandleParameters(puppet, stageBehavior);
							
							stageBehaviorsArray.push(stageBehavior);
							args = new CreateStageBehaviorParamBlock(stageBehaviorsArray[j], backstageBehaviorsArray[j], puppet);
							behaviorJSModules[j].onCreateStageBehavior(stageBehaviorsArray[j], args);
						}

						// sort modules/behaviors in desired order
						dispatchProperties.sort(function(p, q) { return p.order - q.order; });
						puppet.behaviorJSModules = [];
						puppet.stageBehaviorsArray = [];
						dispatchProperties.forEach(function (p) {
							puppet.behaviorJSModules.push(behaviorJSModules[p.index]);
							puppet.stageBehaviorsArray.push(stageBehaviorsArray[p.index]);
						});
						puppet.trackCPath = trackCPath;
					}

					var args = Array.prototype.slice.call(arguments);
					prepBehaviors(args);
				});
			}
			
			function prepPuppetBehaviorInstances (inPuppet, inInstanceInfo, isRootSceneB0)
			{
				var tiBehavior, bb, key, j, stageBehavior, egk, params, stageArrayIdtoIndex = {};

				inPuppet.behaviorBag = inInstanceInfo._behaviorBag;

				// Create Array ID to Index table
				for (j = 0; j < inPuppet.stageBehaviorsArray.length; j += 1) {
					stageArrayIdtoIndex[inPuppet.stageBehaviorsArray[j].behaviorArrayId] = j;
				}
				
				for (key in inPuppet.behaviorBag) {
					if (inPuppet.behaviorBag.hasOwnProperty(key)) {
						bb = inPuppet.behaviorBag[key];
						Z.utils.assert(bb._behaviorArrayID === key);
						
						stageBehavior = inPuppet.stageBehaviorsArray[stageArrayIdtoIndex[key]];
						
						if (stageBehavior && stageBehavior.behaviorArrayId === key) {
							stageBehavior.behaviorBag = bb;
							// We only record behaviors if they are in the root scene
							stageBehavior.behaviorBag._bArmedForRecord = isRootSceneB0 && stageBehavior.behaviorBag._bArmedForRecord && inPuppet.getTrack().getArmedForRecord();

							tiBehavior = new Z.AbstractBehavior("trackItemBehavior");

							tiBehavior.behaviorPPath = stageBehavior.behaviorPPath;
							tiBehavior.behaviorId = stageBehavior.behaviorId;
							tiBehavior.behaviorArrayID = key;
							egk = "/" + tiBehavior.behaviorId + "/";

							// We now publish these when we compile, but not immediately.  Always use
							// published values over static values. This assumes that if the puppet
							// value is published, and the track item value should be used, the
							// track item value was published too.  -jacquave
							params = Z.behaviorUtils.prepParamBagForMergingIntoSkeleton(bb._paramBag);
							Z.behaviorUtils.mergeParams(params, egk, addParameterIdToTrackItemBehavior(bb._instanceID), stageBehavior.pGetParams());
						}
					}
				}				

				inPuppet.getLayers().forEach(function (l) {
					var puppetChild = l.getPuppet(), bindingId, instanceInfo;
					
					if (puppetChild) {
						bindingId = l.getBindingId();
						if (bindingId) {
							instanceInfo = inInstanceInfo._children[bindingId];
							if (instanceInfo) {
								prepPuppetBehaviorInstances(puppetChild, instanceInfo, isRootSceneB0);
							}
						}
					}
				});
			}

			function parsePuppetSuccessFn(puppetParent, trackCPath, isRootSceneB0) 
			{   
				log("puppetParent = " + puppetParent);
				return function (inData)  { 
					log("Run engine.js ...");

					function loadPuppet(varArgs)
					{
						log("loadPuppet");

						log("scene = " + scene);

						log("Request load...");
						Z.Serialize.loadData(inData, function (aContainers, puppet) {
							log("Loading done...");

							log("Make stage...");
							puppetParent.setSourcePuppet(puppet);
							puppetParent.displayInView(stage);

							puppet.breadthFirstEach(function (p) {
								prepPuppetBehaviors(p, trackCPath);
							});
							prepPuppetBehaviorInstances(puppet, puppetParent.getInstanceInfo && puppetParent.getInstanceInfo(), isRootSceneB0);
							
						});
					}

					var args = Array.prototype.slice.call(arguments);
					loadPuppet(args);
				};
			}

			parseChildrenFunc = function (scene, isRootSceneB0)
			{
				log("print Scene Data...");
				var tracks = scene.getChildren(), t, ti, track, trackItems, trackItem, parsePuppet, trackCPathStr, audioClip;

				log("Scene Data, track length = " + tracks.length);
				for (t=0; t < tracks.length; t += 1) {
					track = tracks[t];
					trackItems = track.getChildren();
					log("Scene Data, track items length = " + trackItems.length);
					for (ti=0; ti < trackItems.length; ti += 1) {
						trackItem = trackItems[ti];

						trackCPathStr = ":_aTracks:" + (t+1) + ":_trackItem:" + (ti+1);

						if (trackItem.getTrackSource().getClassInstance() === "Puppet instance") {
							parsePuppet = parsePuppetSuccessFn(trackItem, trackCPath + trackCPathStr, isRootSceneB0);

							log("Puppet = " + trackItem.getTrackSource().getJsonPath());
							parseJSON(trackItem.getTrackSource().getJsonPath(), parsePuppet, failFn);
							log("Loading Puppet done...");
							log("trackItem.puppet = " + trackItem.getSourcePuppet());
						} else if (trackItem.getTrackSource().getClassInstance() === "Scene instance") {
							log("Scene = " + trackItem.getTrackSource().getJsonPath());
							log("Loading Scene done...");
							trackItem.scene = parseScene (trackItem.getTrackSource().getJsonPath(), trackCPath + trackCPathStr, trackItem);
							log("trackItem.scene = " + trackItem.scene);
						} else if (trackItem.getTrackSource().getClassInstance() === "AudioFile instance") {
							log("AudioFile = " + trackItem.getTrackSource().getJsonPath());
							log("Loading AudioFile done...");
							trackItem.audioFile = parseAudioFile (trackItem.getTrackSource().getJsonPath(), trackCPath + trackCPathStr);
							log("trackItem.audioFile = " + trackItem.audioFile);
							
							audioClip = new builder.newAudioMediaClip(trackItem.getTrackSource().getJsonPath() + " Audio Media Clip", trackItem.audioFile.filePath);
							//Z.TimeItem.prototype.clone.call(trackItem, false, audioClip);
							trackItem.getAudioContainer().addChild(audioClip);
							trackItem.attachToRootAudioContainer(stage.getRootAudioContainer());
						}
					}
				}
			};

			parseChildrenFunc(scene, isRootSceneB);

			return scene;
		}

		rootScene = parseScene(__compiledScene);

		/*function printVisibilityRequestMap (visibilityRequestMap)
		{
			var node, nodeName, requests;
			for (nodeName in visibilityRequestMap) {
				if (visibilityRequestMap.hasOwnProperty(nodeName)) {
					node = visibilityRequestMap[nodeName].node;
					requests = visibilityRequestMap[nodeName].requests;
					console.logToUser(node.getName() + "->" + node.getId() + ":");
					requests.forEach(function (r) {
						console.logToUser("\t[ alpha=" + r.alpha + ", enabled=" + r.enabled + ", priority=" + r.priority + ", override=" + r.override + " ]");
					});
				}
			}
		}*/

		function getVisibilityRequestMap (inPuppet)
		{
			var visibilityRequestMap = {}, nodeName, requests,
				compareFunc = function(a, b) {
						return a.priority < b.priority ? 1 : -1;
					};

			inPuppet.breadthFirstEach(function (n) {
				var node, nodeName, requests, requestMap;

				//console.log("e: " + n.getName());
				if (n.replacerInfo && n.replacerInfo.visibilityRequestMap) {

					//console.log("\tvmap:");
					requestMap = n.replacerInfo.visibilityRequestMap;
					for (nodeName in requestMap) {
						if (requestMap.hasOwnProperty(nodeName)) {
							node = requestMap[nodeName].node;
							requests = requestMap[nodeName].requests;
							//console.log("\t\tnode:" + node.getName());
							if (!visibilityRequestMap.hasOwnProperty(nodeName)) {
								visibilityRequestMap[nodeName] = { "node" : node, "requests" : [] };
							}
							visibilityRequestMap[nodeName].requests = visibilityRequestMap[nodeName].requests.concat(requests);
						}
					}
				}
			});

			// sort requests in descending priority order (highest to lowest priority)
			for (nodeName in visibilityRequestMap) {
				if (visibilityRequestMap.hasOwnProperty(nodeName)) {
					requests = visibilityRequestMap[nodeName].requests;			
					requests.sort(compareFunc);
				}
			}

			return visibilityRequestMap;
		}

		function getTrackPuppets (inTime, inScene, ioTimeStack, ioTrackPuppetsArray)
		{
			var tracks = inScene.getChildren(), track, trackItems, trackItem, trackPuppets = ioTrackPuppetsArray || [], 
				t, ti, timeSpan, visibleB, 
				targetDeltaTime = 1 / (inScene.getFrameRate() * inScene.getSimulationRateFactor()),
				rootSceneB = ioTimeStack === undefined;

			if (rootSceneB) {
				ioTimeStack = new Z.TimeStack();
				ioTimeStack.pushTime(null, inScene, {t:inTime, dt:targetDeltaTime});
			}
			
			for (t=0; t < tracks.length; t += 1) {
				track = tracks[t];

				ioTimeStack.pushTime(inScene, track);

				trackItems = track.getChildren();
				
				for (ti=0; ti < trackItems.length; ti += 1) {
					trackItem = trackItems[ti];
					timeSpan = ioTimeStack.pushTime(track, trackItem);
					visibleB = trackItem.isActivateAtTime(timeSpan.t);

					if (visibleB) {
						if (trackItem.getTrackSource().getClassInstance() === "Puppet instance") {
							trackPuppets.push(trackItem.getSourcePuppet());
						} else if (trackItem.getTrackSource().getClassInstance() === "Scene instance") {
							getTrackPuppets(null, trackItem.scene, ioTimeStack, trackPuppets);
						}

					}
					ioTimeStack.popTime();
				}
				
				ioTimeStack.popTime();
			}

			return trackPuppets;
		}

		function doMediateReplacements (trackPuppet)
		{
			var visibilityRequestMap = getVisibilityRequestMap(trackPuppet);

			//console.logToUser("======running replacement mediator for " + trackPuppet.getName());
			//printVisibilityRequestMap(visibilityRequestMap);

			function setAlphaRecursive(layer)
			{
				var alphaToSet = 1, visitedEnabledB = false, nodeName = layer.getId(), requests = [], r, i, highestEnabledRequestPriority = -1;

				//console.logToUser("visiting " + layer.getName());

				// get sorted requests for this node
				if (visibilityRequestMap.hasOwnProperty(nodeName)) {
					requests = visibilityRequestMap[nodeName].requests;
				}	

				if (requests.length > 0) {
					// determine alphaToSet and enabled state based on requests
					for (i = 0; i < requests.length; i += 1) {
						r = requests[i];

						//console.logToUser("\trequest enabled:" + r.enabled + " alpha:" + r.alpha + " pri:" + r.priority);

						// case: overriding
						if (r.override) {
							alphaToSet = r.alpha;
							break;
						}
						// case: have not visited enabled request and r is not enabled
						else if (!visitedEnabledB && !r.enabled) {
							//console.log("\t\tcase 1");
							alphaToSet = (alphaToSet === 1 && r.alpha === 1) ? 1 : 0;
						}
						// case: have not visited enabled request and r is enabled
						else if (!visitedEnabledB && r.enabled) {
							//console.log("\t\tcase 2");
							alphaToSet = r.alpha;
						}

						visitedEnabledB = (visitedEnabledB || r.enabled);

						if (r.enabled && r.priority > highestEnabledRequestPriority) {
							highestEnabledRequestPriority = r.priority;
						}
					}

					// set alpha for node
					//console.logToUser("\tset alpha: " + alphaToSet + " highestEnabledRequestPriority: " + highestEnabledRequestPriority);
					layer.setVisible(alphaToSet > 0);
				}

				// continue traversing if alpha > 0
				if (layer.getVisible()) {
					layer.forEachDirectChildLayer(function (lay) { setAlphaRecursive(lay); });
				}	
			}

			// for each trackItem puppet, setAlphaRecursive
			setAlphaRecursive(trackPuppet.getTrackItem().getSdkLayer());
		}

		
		function doPreMediate (inSceneTime, inScene)
		{
			var trackPuppets = getTrackPuppets(inSceneTime, inScene);
			
			trackPuppets.forEach(function (p) {
				p.breadthFirstEach(function (subPuppet) {
										ReplacerUtilities.clearReplacerInfo(subPuppet);
									});
			});
		}
		
		function doPostMediate (inSceneTime, inScene)
		{
			var trackPuppets = getTrackPuppets(inSceneTime, inScene), rootSdkLayer;
			
			trackPuppets.forEach(function (p) {
				doMediateReplacements(p);
				
				rootSdkLayer = p.getParentLayer().getSdkLayer();
				
				rootSdkLayer.forEachLayerBreadthFirst(function (layer) {
					layer.clearSharedFrameData();
				});
			});
		}

		function doAnimatePuppet (inTrackItem, inEventGraph, ioTimeStack, inRehearseTime)
		{
			return function (p)
			{
				if (p.stageBehaviorsArray) {
					var j, i, recordingB, stoppedB;

					recordingB = stage.isRecording();
					stoppedB = stage.isStopped();
					
					for (j = 0; j < p.stageBehaviorsArray.length; j += 1) {
						if (p.behaviorJSModules) {
							var module = p.behaviorJSModules[j], behavior = p.stageBehaviorsArray[j], behaviorInstanceId, foundEGPileItems = {},
										eventGraphEvaluators = {}, behaviorRehearseTime = inRehearseTime, behaviorArmedB = false, behaviorLiveB = false;

							behaviorInstanceId = behavior.behaviorBag && behavior.behaviorBag._instanceID;
							Z.utils.assert(behaviorInstanceId, "Unknown behaviorInstanceId");
							
							if (behavior.behaviorBag && behavior.behaviorBag._egPile) {
								behaviorArmedB = behavior.behaviorBag._bArmedForRecord;
								behaviorLiveB = behaviorArmedB && (stoppedB || recordingB);

								if (stoppedB && !behaviorArmedB) {
									behaviorRehearseTime = 0.0; // ignore preview time when evaluating the event graphs.
								}

								var egPile = behavior.behaviorBag._egPile._aPileItems;
								for (i = egPile.length-1; i >= 0; i -= 1) {
									var egPileItem = egPile[i];

									var	paramId = egPileItem.getParamId();
									if (!foundEGPileItems[paramId] && behavior.params[paramId]) {
										var armedForRecordOnB = isParamArmedForRecord(behavior, paramId);

										if (!(behaviorLiveB && armedForRecordOnB)) {
											// Last overrides prior, so start from the bottom.
											var timeSpan = ioTimeStack.pushTime(inTrackItem, egPileItem);

											if (egPileItem.isActivateAtTime(timeSpan.t)) {
												var eventGraphFilePath0 = egPileItem && egPileItem.getFilePath();
												foundEGPileItems[paramId] = egPileItem;
												eventGraphEvaluators[paramId] = inEventGraph.getEvaulator(behaviorInstanceId, timeSpan, eventGraphFilePath0);
											}

											ioTimeStack.popTime();
										}
									}
								}
							}
							var args = new BehaviorParamBlock(rootScene, behavior, behaviorInstanceId, inEventGraph, ioTimeStack, inRehearseTime, behaviorRehearseTime, behaviorLiveB, p, eventGraphEvaluators);
							// ZoneProfiler.push("onAnimate");
							module.onAnimate(behavior, args);
							// ZoneProfiler.pop();
						}
					}
				}
			};
		}

		doAnimate = function (inSceneTime, inRehearseTime, inScene, ioTimeStack) {
			var tracks = inScene.getChildren(), visibleB, timeSpan, t, ti, track, trackItems, trackItem, eventGraph,
				targetDeltaTime = 1 / (inScene.getFrameRate() * inScene.getSimulationRateFactor()), firstCalled = firstAnimateCalled, 
				rootSceneB = ioTimeStack === undefined;

			if (rootSceneB) {
				ioTimeStack = new Z.TimeStack();
				ioTimeStack.pushTime(null, inScene, {t:inSceneTime, dt:targetDeltaTime});
			}
			
			firstAnimateCalled = true;
			eventGraph = Z.nml.getEventGraph(rootScene.getTrackItemSource().getPPathString());

			for (t=0; t < tracks.length; t += 1) {
				track = tracks[t];

				ioTimeStack.pushTime(inScene, track);

				trackItems = track.getChildren();
				
				for (ti=0; ti < trackItems.length; ti += 1) {
					trackItem = trackItems[ti];

					timeSpan = ioTimeStack.pushTime(track, trackItem);

					visibleB = trackItem.isActivateAtTime(timeSpan.t);

					if (trackItem.getDisplayContainer && trackItem.getDisplayContainer() && visibleB !== trackItem.getDisplayContainer().getVisibleEnabled()) {
						trackItem.getDisplayContainer().setVisibleEnabled(visibleB);
					}

					if (visibleB) {
						if (trackItem.getTrackSource().getClassInstance() === "Puppet instance") {
							trackItem.getSourcePuppet().breadthFirstEach(doAnimatePuppet(trackItem, eventGraph, ioTimeStack, inRehearseTime));
							trackItem.getSdkLayer().privateLayer.warp();
						} else if (trackItem.getTrackSource().getClassInstance() === "Scene instance") {
							doAnimate(null, inRehearseTime, trackItem.scene, ioTimeStack);
						}
					}
					ioTimeStack.popTime();
				}
				
				ioTimeStack.popTime();
			}

			// ZoneProfiler.report(10);
	
			if (rootSceneB) {
				ioTimeStack.popTime();
				Z.utils.assert(ioTimeStack.getSize() === 0, "Time Stack not balanced");
			}
			
			if (!firstCalled && stage) {
				stage.setCurtainsOpen(true);
			}

			if (rootSceneB) {
				eventGraph.update(inSceneTime + inRehearseTime);
			}
		};

		if (stage && rootScene) 
		{
			stage.addTimerNotifier(
				function (inSceneTime, inRehearseTime) {
					doPreMediate(inSceneTime, rootScene);
					// ZoneProfiler.push("doAnimate");
					doAnimate(inSceneTime, inRehearseTime, rootScene);
					// ZoneProfiler.pop();
					doPostMediate(inSceneTime, rootScene);
				}
			);
			
			stage.readyForAction();
		}
	});
} ());
