define(["src/utils"],
function (utils) {
	"use strict";

	function resetReplacerInfo(inPuppet) {
		// create and initialize replacerInfo if necessary
		if (!inPuppet.replacerInfo) {
			inPuppet.replacerInfo = { "visibilityRequestMap": {}, "t": 0 };
		}
	}

	// WL: updateReplacerInfo and updateVisitedMap could be methods of the
	// replacerInfo object itself
	function updateReplacerInfo(args) {
		// create and initialize replacerInfo if necessary
		if (args.stagePuppet) {
			resetReplacerInfo(args.stagePuppet);
		}
	}

	function clearReplacerInfo(inPuppet) {
		delete inPuppet.replacerInfo;
		resetReplacerInfo(inPuppet);
	}

	function applyReplacements(self, args, replacerPriority, replacerDoesOverrideB, nodesToShow, nodesToHide) {
		var replacerInfo = args.stagePuppet.replacerInfo,
			requestMap, rootPreviewTime;

		if (!replacerInfo) {
			return;
		}

		requestMap = replacerInfo.visibilityRequestMap;

		function addVisibilityRequest(node, alpha, enabled, priority, override, requestMap) {
			var request = { "alpha": alpha, "enabled": enabled, "priority": priority, "override": override },
				nodeId = node.getId();

			if (!requestMap.hasOwnProperty(nodeId)) {
				requestMap[nodeId] = { "node": node, "requests": [] };
			}
			requestMap[nodeId].requests.push(request);
		}

		// create visibility requests for nodesToHide and nodesToShow
		nodesToHide.forEach(function (n) {
			addVisibilityRequest(n.node, 0, n.enabled, replacerPriority, replacerDoesOverrideB, requestMap);
		});

		nodesToShow.forEach(function (n) {
			addVisibilityRequest(n.node, 1, n.enabled, replacerPriority, replacerDoesOverrideB, requestMap);
		});
	}

	function removeConflicts(nodesToShow, nodesToHide) {
		var cleanNodesToShow, cleanNodesToHide;

		function nodeEnabledInList(node, list) {
			var inList = false;
			list.forEach(function (entry) {
				if (node === entry.node && entry.enabled) {
					inList = true;
				}
			});

			return inList;
		}

		function cleanList(list, otherList) {
			var newList = [];
			list.forEach(function (entry) {
				var node = entry.node, enabled = entry.enabled;
				if (enabled || !nodeEnabledInList(node, otherList)) {
					newList.push(entry);
				}
			});
			return newList;
		}

		cleanNodesToShow = cleanList(nodesToShow, nodesToHide);
		cleanNodesToHide = cleanList(nodesToHide, nodesToShow);

		return { "nodesToShow": cleanNodesToShow, "nodesToHide": cleanNodesToHide };
	}

	return {
		updateReplacerInfo: updateReplacerInfo,
		clearReplacerInfo: clearReplacerInfo,
		applyReplacements: applyReplacements,
		removeConflicts: removeConflicts
	};
});
