define(["lib/Zoot", "src/math/Vec2", "src/math/Mat3", "lodash", "src/utils", "src/build/VisualMarks"],
function (Z, vec2, mat3, lodash, utils, VisualMarks) {
	"use strict";


	function forEachShownLayer (self, args, fn) {
		var classIndex = 0,
			layerIndex = 0,
			layerNum = 0;
		args.stageLayer.forEachLayerBreadthFirst(function (sdkLayer) {
			var layer = sdkLayer.privateLayer;
			if (layer.getWarpWithParent()) return;
			if (layerIndex+1 < self.layerStart) { // layerIndex is zero-based and layerStart is one-based.
				layerIndex += 1;
				return;
			}

			if (classIndex+1 > self.layerNum) return false;

			utils.assert(classIndex < 12);

			fn(layer, classIndex, layerIndex);

			classIndex += 1;
			layerIndex += 1;
			layerNum += 1;
		});
	}


	function update (self, args) {
		var markIndex = 0;

		forEachShownLayer(self, args, function (layer) {
			var aMatLayer_Leaf = layer.gatherHandleLeafMatrixArray("layer"),
				matScene_Layer = args.getLayerMatrixRelativeToScene(layer);

			aMatLayer_Leaf.forEach(function (matLayer_Leaf) {
				var mark = self.leafMarks.getMarkAtIndex(markIndex);
				mark.setMatrix(mat3.multiply(matScene_Layer, matLayer_Leaf));
				markIndex += 1;
			});
		});

	}

	function create (self, args) {
		self.leafMarks = new VisualMarks({ opacity : self.opacity / 100 });

		forEachShownLayer(self, args, function (layer, classIndex) {
			var aMatLayer_Leaf = layer.gatherHandleLeafMatrixArray("layer"),
				matScene_Layer = args.getLayerMatrixRelativeToScene(layer);

			aMatLayer_Leaf.forEach(function (matLayer_Leaf) {
				var mark = self.leafMarks.square(self.markSize, classIndex);
				self.leafMarks.insertMark(mark);
				mark.setMatrix(mat3.multiply(matScene_Layer, matLayer_Leaf));
			});

		});

		self.leafMarks.addToDisplayItem(args.stageLayer.privateLayer.getTrackItem());
	}

	function remove (self, args) {
		if (self.leafMarks) {
			self.leafMarks.removeFromDisplayItem(args.stageLayer.privateLayer.getTrackItem());
			self.leafMarks = null;
		}
	}

	return {
		about: "ShowWarperHandles, (c) 2014.",
		description: "$$$/Animal/Behavior/ShowWarperHandles/Desc=Shows all warper handles",
		uiName: 	"$$$/Animal/Behavior/ShowWarperHandles/UIName=Show Warper Handles",
		defaultArmedForRecordOn: false,
		hideInBehaviorList: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			var params = [
				{
					id : "markSize",
					type : "slider",
					uiName : "Mark Size",
					min : 1,
					max : 100,
					dephault : 20
				},
				{
					id : "opacity",
					type : "slider",
					uiName : "Opacity",
					uiUnits : "%",
					min : 0,
					max : 100,
					precision : 0,
					dephault : 50
				},
				{
					id : "layerStart",
					type : "slider",
					uiName : "First Layer to Show",
					min : 1,
					max : 100,
					dephault : 1
				},
				{
					id : "layerNum",
					type : "slider",
					uiName : "Number of Layers",
					min : 1,
					max : 12,
					dephault : 12
				}
			];

			return params;
		},

		onCreateBackStageBehavior: function (self) {
		},

		onCreateStageBehavior: function (self, args) {
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage
			var markSize = args.getParam("markSize"),
				opacity = args.getParam("opacity"),
				layerStart = args.getParam("layerStart"),
				layerNum = args.getParam("layerNum");

			if (
				markSize !== self.markSize ||
				opacity !== self.opacity ||
				layerStart !== self.layerStart ||
				layerNum !== self.layerNum
			) {
				remove(self, args);
			}

			if (self.leafMarks) {
				update(self, args);
			} else {
				self.markSize = markSize;
				self.opacity = opacity;
				self.layerStart = layerStart;
				self.layerNum = layerNum;
				create(self, args);
			}
		}

	}; // end of object being returned
});
