
define(	["lib/Zoot"],
	function(Z) {
		"use strict";
		console.log("creating Sample behavior");
		return {
			uiName:	"Sample Behavior",
			hideInBehaviorList: true, // REMOVE THIS TO HAVE THE BEHAVIOR SHOW UP IN THE UI! (or hold down opt/alt when clicking the menu)
			defaultArmedForRecordOn: true,
	
			defineParams: function () {
				return [
						// ==== implemented types ====
                    	// uiName and uiUnits may be zstrings.
                        {id:"baz",      type:"slider",   uiName:"$$$/animal/Behaviors/Sample/Params/baz=Baz", uiUnits:"$$$/animal/Behaviors/Sample/Units/pixsec=pix/sec", min:0, max:100, sliderMin: 0, sliderMax: 10, increment:1, dephault:7},
                        {id:"speed",    type:"slider",   uiName:"Speed", uiUnits:"pix/sec", min:0, max:100, sliderMin: 0, sliderMax: 10, increment:1, dephault:7},
                        {id:"flow",     type:"angle",    uiName:"Flow Direction", increment:45, dephault:180},
                        {id:"gpu",      type:"checkbox", uiName:"Use GPU", dephault:false},
                        {id:"method",   type:"enum",     uiName:"Method",
							 // items is an array; that's the UI presentation order. id must be numeric. An item with no name & no id is a separator.
							 items:[ {id:0, uiName:"Very Fast"}, {id:17, uiName:"Medium"}, {id:35, uiName:"Slow"}, { }, {id:36, uiName:"Automatic"} ],
							 dephault:17 },
						{id: "mygroup", type:"group", uiName: "Pointy-Slider Group", twirledOpen:true, groupChildren:[
							{id:"fabulousness", type:"slider", uiName:"Fabulousness", min:0, max:10, precision:2, dephault:0},
							{id:"myinnergroup", type:"group", uiName: "Extra Twirly Group", twirl:1, groupChildren:[
								{id:"craziness", type:"slider", uiName:"Craziness", min:0, max:10, dephault:0}
							 ]}
						 ]},
						{id:"smileLayer",	type:"layer", uiName:"Smile Texture", dephault:{match:"//Smile"}, maxCount:1,
						 	uiToolTip:"Layer to use for smiling"}, // resolves to a layer in this puppet or nested puppet
						{id:"target",		type:"handle", uiName:"Target", dephault:{match:"//Nose"}, maxCount:2}, // handle param that gets bound to one or more handles

						// ==== not yet implemented types ====
/*					,	{id:"myMousePos",	type:"eventGraph", dephault: "Mouse"},
						{id:"center",		type:"point", uiName:"Center", dephault: [0, 0, 0], desc:"This is the center of the fib-fab"},
						{id:"doSomething",	type:"button", uiName:"My Buttons", items:[{id:3, uiName:"First Button"}, {id:"reset", uiName:"Reset"}]},
						{id:"bgColor",		type:"color", uiName:"Background Color", dontAnimate:true, defaultForOldInstances:[0.5, 0, 0, 1], dephault:[1,0,0,1]}, 
*/
						 // not yet implemented parameter fields: hidden, disabled, experimental (show only when experimental params enabled),
						 //		defaultForOldInstances (used when converting from an old param definition),
						 //		dontAnimate (prevents recording of event graphs for this param, disables it during playback and recording? but still active in live monitoring mode?
						//			mainly used for controls that control other controls?)
						//		twirledOpen (was called "open") -- for groups only
				];
			},
	
			onCreateBackStageBehavior: function (self) {
			},
		
			onCreateStageBehavior: function (self, args) {
			},
			
			//  args includes getParam(id); if needed could add a query for all params at once
			onUserChangedParam: function (self, args, id, newValue) {
				return {  // all fields are optional
					errorMsg : "Something bad happened",
					setParamValues : { baz: 8, center: [10, 10, 10] }, // set any or all params here to change them
					redefineParams : [ /* full definition */ ] // same return type as defineParams()
				};
			},
	
			// method on behavior that is attached to a puppet onstage, called once per frame
			//  args includes t, dt, stagePuppet, getParam(id), getParamEventValue()
			onAnimate: function (self, args) {
			}
		};
	}
);

