/*global define, require, console */
/*jslint white: true, nomen: true */

define(["lib/Zoot"], 
function (Z) {
	'use strict';

	var kAbout = "Replicator, (c) 2014.",
		rKeyCode = Z.keyCodes.getKeyGraphId("R"),
		dKeyCode = Z.keyCodes.getKeyGraphId("D");

    return {
		about: kAbout,
		description: "$$$/Animal/Behavior/Replicator/Desc=Replicates an object",
		uiName:	"$$$/Animal/Behavior/Replicator/UIName=Replicator",
		hideInBehaviorList: true, // REMOVE THIS TO HAVE THE BEHAVIOR SHOW UP IN THE UI! (or hold down opt/alt when clicking the menu)
		defaultArmedForRecordOn: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{
					id: "ReplicateWhileMouseDown",
					type: "checkbox",
					uiName: "Replicate While Mouse Down",
					dephault: false
				},
				{id:"MouseInput", type:"eventGraphInput", uiName:"Mouse Input",	inputKeysArray:["Mouse/"], uiToolTip:"Mouse input used for object creation", defaultArmedForRecordOn: true},
				{id:"KeyboardInput", type:"eventGraphInput", uiName:"Keyboard Input", inputKeysArray:[rKeyCode, dKeyCode], uiToolTip:"Keyboard input used to interact to create and delete objects", defaultArmedForRecordOn: true}
			];
		},

		onCreateBackStageBehavior: function (self) {
			// method on backstage behavior just before it is attached to a puppet; self is the new backstage behavior
			// which will contain these properties: boundPuppet, projectBehavior, getParam(id)/setParam(id, value) [or just allow this.id syntax?], addParam(), removeParam(),  
			// here you might walk the handles of your puppet and bind handle parameters or change defaults accordingly
			// the already-bound other behaviors can be examined, and this function can return a suggested index for its order,
			// and also its priority (i.e. how many simulation time-slices per rendered frame)
		},

		onCreateStageBehavior: function (self, args) {
			self.lastDown = 0;
			self.puppets = [];
			self.replicatorTrack = null;
		},

		onParamChanged: function (self, id, oldValue, newValue) { // method on behavior (any phase)
			Z.Utils.assert(false, kAbout + " not expecting onParamChanged()");
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage

			var rDown = args.getParamEventValue("KeyboardInput", rKeyCode) || 0,
				dDown = args.getParamEventValue("KeyboardInput", dKeyCode) || 0,
				handle, mat3, invMtx, mtxData, puppetBounds, aPuppetCorners = [],
				trackItem, track, scene, newTrackItem, newTrack, newPuppet, view, i, p,
				mousePosition = args.getParamEventValue("MouseInput", "Mouse/Position"), rootPosition,
				overValue = args.getParamEventValue("MouseInput", "Mouse/Over"),
				leftDownB = args.getParamEventValue("MouseInput", "Mouse/Down/Left");


			if (dDown) {
				args.setInputParamUsedDuringRecording("KeyboardInput");
				for (i = 0; i < self.puppets.length; i += 1) {
					p = self.puppets[i];
					trackItem = p.getTrackItem();
					p.removeFromView(p.getView());
					trackItem.getParentDisplayContainer().removeChild(trackItem.getDisplayContainer());
					self.replicatorTrack.removeChild(newTrackItem);
				}
				self.puppets = [];
			} else if (overValue && mousePosition) {
				var rChanged = rDown > self.lastDown, downReplicateB = leftDownB && args.getParam("ReplicateWhileMouseDown");
				if (downReplicateB || rChanged) {
					if (rChanged) {
						args.setInputParamUsedDuringRecording("KeyboardInput");
					}
					if (downReplicateB) {
						args.setInputParamUsedDuringRecording("MouseInput");
					}

					self.lastDown = rDown;
					trackItem = args.stagePuppet.getTrackItem();
					newTrackItem = trackItem.clone();
					if (self.replicatorTrack) {
						newTrack = self.replicatorTrack;
					} else {
						newTrack = new Z.Track("Replicator Track", true);
						self.replicatorTrack = newTrack;
					}
					newTrack.addChild(newTrackItem);

					newPuppet = args.stagePuppet.clone();
					handle = newPuppet.getHandleTreeRoot();

					newTrackItem.puppet = newPuppet;
					newPuppet.setParent(newTrackItem);

					scene = args.stagePuppet.getScene();
					scene.addChild(newTrack);	// We will display it in the view next, but add it to the scene too.

					// add new puppet/item to view and track
					view = args.stagePuppet.getView();
					newPuppet.displayInView(view);

					invMtx = Z.Mat3.invert(args.getPuppetMatrixRelativeToScene(args.stagePuppet));
					
					rootPosition = [0, 0];
					Z.Vec2.transformAffine(invMtx, mousePosition, mousePosition);
					Z.Vec2.transformAffine(handle.getMatrix(), rootPosition, rootPosition);

					Z.Vec2.subtract(mousePosition, rootPosition, rootPosition);
					mat3 = Z.Mat3.translation(rootPosition);
					
					handle.setMatrix(Z.Mat3.multiply(handle.getMatrix(), Z.Mat3.clone(mat3)));
					
					newPuppet.warp();
					self.puppets.push(newPuppet);
				}
			}
		}

	}; // end of object being returned
});
