define(["lib/Zoot", "lib/ReplacerUtilities"],
function (Z, ReplacerUtilities) {
	"use strict";


	var kReplacerPriority = 1.2,       // TODO: make this user-specified param 
		kReplacerDoesOverride = false; // TODO: make this user-specified param (what name?)

/*	function printKeyMap(self) {
		var keyName, i, j;
		for (keyName in self.keyMap) {
			if (self.keyMap.hasOwnProperty(keyName)) {

				console.logToUser("key " + keyName);

				for (i = 0; i < self.keyMap[keyName].length; i += 1) {

					console.logToUser("\tentry" + i);
					console.logToUser("\t\tnodeToShow " + self.keyMap[keyName][i].nodeToShow.getName() + "--" + self.keyMap[keyName][i].nodeToShow.getId());
					for (j = 0; j < self.keyMap[keyName][i].nodesToHide.length; j += 1) {
						console.logToUser("\t\tnodeToHide " + self.keyMap[keyName][i].nodesToHide[j].getName() + "--" + self.keyMap[keyName][i].nodesToHide[j].getId());
					}
				}

			}
		}
	}*/

	// May want to replace following three linear search functions with a hash table if performance becomes an issue
	// (e.g., with lots of key replacements that result in long node lists)

	function nodeInList(node, nodeObjList) {
		var i;

		for (i = 0; i < nodeObjList.length; i += 1) {
			if (node === nodeObjList[i].node) {
				return true;
			}
		}

		return false;
	}

	function removeNodeFromList(node, nodeObjList) {
		var resultList = [];

		nodeObjList.forEach(function (n) {
			if (node !== n.node) {
				resultList.push(n);
			}
		});

		return resultList;
	}

	function nodeInKeyMap(self, node) {
		var keyName, i;

		for (keyName in self.keyMap) {
			if (self.keyMap.hasOwnProperty(keyName)) {
				for (i = 0; i < self.keyMap[keyName].length; i += 1) {
					if (self.keyMap[keyName][i].nodeToShow === node) {
						return true;
					}
				}
			}	
		}

		return false;
	}

	function constructKeyMap(self, rootLayer) {
		self.keyMap = {};

		var keyLayerRegExp = new RegExp(/\((\S)(\S?)\)/);

		rootLayer.forEachLayerBreadthFirst(function (lay) {
			var pName = lay.getName(), keyName, modifierName, newReplacementGroup = {}, pSiblings = [], 
				parentKeyName, parentModifierName, parentPuppet = lay.getParentPuppet(), parentName;

			// skip toplevel puppet
			if (lay === rootLayer) {
				return;
			}

			//console.logToUser("examining " + lay.getName() + "--" + lay.getId() + " --> " + parentPuppet.getName());

			if (keyLayerRegExp.test(pName)) {

				keyName = keyLayerRegExp.exec(pName)[1].toUpperCase();
				modifierName = keyLayerRegExp.exec(pName)[2];

				// if current layer is the sole child, and parent layer
				// is associated with the same key and modifier, then skip
				// so that we don't add duplicate redundant replacement entries
				if (parentPuppet && parentPuppet.getLayers().length == 1) {
					parentName = parentPuppet.getName();
					if (keyLayerRegExp.test(parentName)) {
						parentKeyName = keyLayerRegExp.exec(parentName)[1];
						parentModifierName = keyLayerRegExp.exec(parentName)[2];

						if (parentKeyName == keyName && parentModifierName == modifierName) {
							//console.logToUser("skipped " + parentPuppet.getName());
							return;
						}
					}
				}

				if (modifierName === "!") {
					if (parentPuppet) {
						pSiblings = parentPuppet.getLayers(); // so these are raw layers
					}
				}

				newReplacementGroup.nodeToShow = lay;
				newReplacementGroup.nodesToHide = [];
				pSiblings.forEach(function (sib) {
					var sdkLayer = sib.getSdkLayer();
					if (sdkLayer !== lay && sdkLayer.getVisible()) {
						newReplacementGroup.nodesToHide.push(sdkLayer);
					}
				});

				if (self.keyMap.hasOwnProperty(keyName)) {
					self.keyMap[keyName].push(newReplacementGroup);
				}
				else {
					self.keyMap[keyName] = [newReplacementGroup];
				}				
			}
		});

		// debug -- show key mappings
		//printKeyMap(self);

	}

	function isKeyDown(args, inKeyName) {
		return args.getParamEventValue("KeyboardInput", Z.keyCodes.getKeyGraphId(Z.keyCodes.getKeyCode(inKeyName))) || 0;		
	}

/*	function printNodesToShowHide(nodesToShow, nodesToHide) {
		console.log("nodesToShowHide:");
		nodesToShow.forEach(function (n) {
			console.log("\tshw:" + n.node.getName() + " " + n.enabled);
		});
		nodesToHide.forEach(function (n) {
			console.log("\thide:" + n.node.getName() + " " + n.enabled);
		});		
	}
*/

	function chooseKeyReplacements(self, args) {
		var keyName, keyDown, replacementGroups, replacementGroup, i, j, 
			nodesToShow = [], nodesToHide = [], nodeObj, 
			visitedMutexNodesToHide = [], skipGroup,
			cleanResult;

		for (keyName in self.keyMap) {
			if (self.keyMap.hasOwnProperty(keyName)) {

				keyDown = isKeyDown(args, keyName);
				if (keyDown) {
					args.setInputParamUsedDuringRecording("KeyboardInput");
				}

				replacementGroups = self.keyMap[keyName];

				for (i = 0; i < replacementGroups.length; i += 1) {
					replacementGroup = replacementGroups[i];

					// if nodeToShow has been hidden already, skip this replacementGroup
					skipGroup = nodeInList(replacementGroup.nodeToShow, visitedMutexNodesToHide);
					if (skipGroup) {
						continue;
					}

					// show/hide appropriate nodes
					if (keyDown) {

						// if keyDown and there are nodesToHide, this is a mutex replacementGroup
						for (j = 0; j < replacementGroup.nodesToHide.length; j += 1) {
							nodeObj = {"node" : replacementGroup.nodesToHide[j], "enabled" : true};
							nodesToHide.push(nodeObj);
							visitedMutexNodesToHide.push(nodeObj);

							// if this nodeToHide has been added to enabledNodesToShow, 
							// remove it to avoid violating mutex visibility
							nodesToShow = removeNodeFromList(nodeObj.node, nodesToShow);
						}

						nodesToShow.push({"node" : replacementGroup.nodeToShow, "enabled" : true});
					} 
					else {
						for (j = 0; j < replacementGroup.nodesToHide.length; j += 1) {
							nodesToShow.push({"node" : replacementGroup.nodesToHide[j], "enabled" : false});
						}
						nodesToHide.push({"node" : replacementGroup.nodeToShow, "enabled" : false});
					}
				}
			}
		}

		cleanResult = ReplacerUtilities.removeConflicts(nodesToShow, nodesToHide);

		// DEBUG
		//printNodesToShowHide(cleanResult.nodesToShow, cleanResult.nodesToHide);

		return cleanResult;
	}


	return {
		about: 			"Keyboard Triggers, (c) 2014.",
		description: 	"$$$/Animal/Behavior/KeyReplacer/Desc=Hides and shows artwork based on keyboard shortcuts",
		uiName:  		"$$$/Animal/Behavior/KeyReplacer/UIName=Keyboard Triggers",
		defaultArmedForRecordOn: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{id:"KeyboardInput", type:"eventGraphInput", uiName:"Keyboard Input", inputKeysArray:["Keyboard/"], uiToolTip:"Keyboard input used to hide and show artwork", defaultArmedForRecordOn: true}
			];
		},

		onCreateBackStageBehavior: function (/*self*/) {
			// method on backstage behavior just before it is attached to a puppet; self is the new backstage behavior
			// which will contain these properties: boundPuppet, projectBehavior, getParam(id)/setParam(id, value) [or just allow this.id syntax?], addParam(), removeParam(),  
			// here you might walk the handles of your puppet and bind handle parameters or change defaults accordingly
			// the already-bound other behaviors can be examined, and this function can return a suggested index for its order,
			// and also its priority (i.e. how many simulation time-slices per rendered frame)
			return { order: 1.1, importance : 0.0 };
		},

		onCreateStageBehavior: function (self, args) {
			// method on stage behavior just before it is instanced on stage; self is the new stage behavior which
			// contains these properties: backstageBehavior, getParam(id)/setParam(id, value) [or just allow this.id syntax?], addParam(), removeParam(). 
			// here you might initialize simulation state
			constructKeyMap(self, args.stageLayer);
			ReplacerUtilities.updateReplacerInfo(args);
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage	
			var replNodes = chooseKeyReplacements(self, args);
			ReplacerUtilities.applyReplacements(self, args, kReplacerPriority, kReplacerDoesOverride, replNodes.nodesToShow, replNodes.nodesToHide);
		}

	}; // end of object being returned
});
