/*jshint unused: vars */

define(["lib/Zoot"],
function (Z) {
	"use strict";

	return {
		about: "Nutcracker Jaw, (c) 2014.",
		description: "$$$/Animal/Behavior/NutcrackerJaw/Desc=Flaps a jaw up and down based on tracking the openness of your mouth",
		uiName: "$$$/Animal/Behavior/NutcrackerJaw/UIName=Nutcracker Jaw",
		defaultArmedForRecordOn: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{id:"cameraInput",		type:"eventGraphInput", uiName:"Camera Input", inputKeysArray:["Head/MouthDY"], uiToolTip:"Analyzed face data from the camera",						defaultArmedForRecordOn: true},
				{id:"targets", type:"handle", uiName:"Target Handles", dephault:{match:"//jaw"} },
				{id:"jawFactor", type:"slider", uiName:"Flappiness", uiUnits:"%", dephault:100}
			];
		},
		
		onCreateBackStageBehavior: function (self) {
			return { order: 1.0, importance : 0.0 };
		},

		onCreateStageBehavior: function (self, args) {
			self.targets = args.getStaticParam("targets");
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage		
			var chinMovement, deltaChinMovement, factor, mouthHeight, chinHeight;
			
			if (self.targets.length < 1) {
				return;
			}

			factor = args.getParam("jawFactor") * 0.01;
			
			mouthHeight = args.getParamEventValue("cameraInput", "Head/MouthDY");
			
			if (mouthHeight !== undefined) {
				args.setInputParamUsedDuringRecording("cameraInput");
				//console.logToUser(mouthHeight);
				if (mouthHeight < 0) {
					mouthHeight = 0;		// clamp it so it only gets more open, not more closed
				}
				
				chinHeight = 100; // TODO: measure instead

				chinMovement = mouthHeight * factor * chinHeight;
				
				if (self.prevChinMovement === undefined) {
					deltaChinMovement = chinMovement;
				} else {
					deltaChinMovement = chinMovement - self.prevChinMovement;
				}
				self.prevChinMovement = chinMovement;

				self.targets.forEach(function (h, i) {
					h.setMatrix(h.getMatrix(Z.Mat3()).translate([0, deltaChinMovement]));
				});
			}
		}

	}; // end of object being returned
});
