/* Adobe.Breathe.js -- Breath behavior for Animal */

define(["lib/Zoot"],
function (Z) {
	"use strict";

	return {
		about: "Breathe behavior",
		description: "$$$/Animal/Behavior/Breathe/Desc=Smoothly grows and shrinks the chest to look like breathing",
		uiName: "$$$/Animal/Behavior/Breathe/UIName=Breathe",
		defaultArmedForRecordOn: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{id:"targetHandles",		type:"handle", uiName:"Chest Handles", dephault:{match:"//chest"} },
				{id:"rate", type:"slider", uiName:"Breaths per Minute", precision:1, dephault:40, "min":0, "max":500},
				{id:"maxScale", type:"slider", uiName:"Max Scale", precision:1, uiUnits:"%", dephault:400},
				{id:"minScale", type:"slider", uiName:"Min Scale", precision:1, uiUnits:"%", dephault:100},
				{id:"moveOffset", type:"slider", uiName:"Offset", precision:1, dephault:25, "min":0, "max":5000,
					uiToolTip:"$$$/Animal/Behavior/Breathe/Offset/ToolTip=Distance to move Chest Handles when breathing in."},
				{id:"moveDirection", type:"angle", uiName:"Direction", precision:0, dephault:0,
					uiToolTip:"$$$/Animal/Behavior/Breathe/Direction/ToolTip=Direction to move Chest Handles when breathing in."},
			];
		},

		onCreateBackStageBehavior: function () {
		},

		onCreateStageBehavior: function (self, args) {
			self.targetHandles = args.getStaticParam("targetHandles");
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage		
			var mat3, s, osc, pos, angle, rad, minScale, maxScale, rate, dist, t = args.t + args.globalRehearseTime;
			
			if (self.targetHandles.length === 0) {
				return;
			}

			minScale = args.getParam("minScale") * 0.01;
			maxScale = args.getParam("maxScale") * 0.01;
			dist = -args.getParam("moveOffset");
			angle = args.getParam("moveDirection");
			
			rate = args.getParam("rate");

			self.lastT = self.lastT || t;
			self.phase = self.phase || 0;

			self.phase += (t-self.lastT)*(rate/60)*Math.PI*2;
			self.lastT = t;
			osc = ((Math.sin(self.phase)+1)*0.5);
			s = osc * (maxScale-minScale) + minScale;
			pos = [0, osc*dist];
			rad = (angle * Math.PI*2) / 360.0;
			
			pos = Z.Vec2.transformAffine(Z.Mat3.rotation(rad), Z.Vec2.initWithArray(pos));
			
			mat3 = Z.Mat3.multiply(Z.Mat3.scaling([s, s]), Z.Mat3.translation(pos));

			self.targetHandles.forEach(function (h) {
				h.setMatrix(Z.Mat3.clone(mat3));
			});
		}

	}; // end of object being returned
});
