/*jshint unused: vars */

define(["lib/Zoot", "lib/ReplacerUtilities"],
function (Z, 		ReplacerUtilities) {
	"use strict";

	var kAbout = "Blinker, (c) 2014.",
		kReplacerPriority = 1.1,       // TODO: make this user-specified param 
		kReplacerDoesOverride = false, // TODO: make this user-specified param (what name?)
		closed,
		lastSwitchT, 						// time of last switch (open or closed)
		duration;							// duration of current state (open or closed)

	function chooseBlinkReplacements (self, inClosed) {
		var nodesToShow = [], nodesToHide = [];

		self.blinkPuppetPairs.forEach(function (pPair) {
			var blinkLayer = pPair[0], replGroup = pPair[1];

			replGroup.forEach(function (p) {
				if (inClosed) {
					nodesToHide.push({"node" : p, "enabled" : true});					
				} else {
					nodesToShow.push({"node" : p, "enabled" : false});					
				}
			});

			if (inClosed) {
				nodesToShow.push({"node" : blinkLayer, "enabled" : true});
			} else {
				nodesToHide.push({"node" : blinkLayer, "enabled" : false});
			}
		});

		return {"nodesToShow" : nodesToShow, "nodesToHide" : nodesToHide};
	}	

	function getGaussianRandomNumber (inMean, inStdev) {
		var x, 					// x is a zero-mean normally distributed random number computed via Box-Muller transform
			y, 					// y is x transformed with specified mean and stdev
			r1 = 0, r2 = 0, 	// r1 and r2 are uniformly distributed random numbers
			epsilon = 0.00001;

		while (r1 * r2 < epsilon) {
			r1 = Math.random();
			r2 = Math.random();
		}

		x = Math.sqrt(-2.0 * Math.log(r1)) * Math.cos(2.0 * Math.PI * r2);

		y = inStdev * x + inMean;

		return y;
	}

	function getDuration (inClosed, inRate, inLength, inRandomness) {
		var duration = 0, rateInS, lengthInS, stdev;

		rateInS = (inRate > 0) ? (60.0 / inRate) : -1.0;
		lengthInS = inLength / 1000.0;
		stdev = (inRandomness / 100.0) * rateInS;

		if (inClosed) {
			duration = getGaussianRandomNumber(lengthInS, 0.0);
		}
		else {
			duration = getGaussianRandomNumber(rateInS, stdev);
		}

		return duration;
	}

	return {
		about: 			kAbout,
		description: 	"$$$/Animal/Behavior/Blinker/Desc=Blink at specified rate",
		uiName:  		"$$$/Animal/Behavior/Blinker/UIName=Blinker",
		hideInBehaviorList: true, // REMOVE THIS TO HAVE THE BEHAVIOR SHOW UP IN THE UI! (or hold down opt/alt when clicking the menu)
		defaultArmedForRecordOn: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{id:"rate", type:"slider", uiName:"Blinks per Minute", precision:1, dephault:30, "min":0, "max":500},
				{id:"length", type:"slider", uiName:"Blink Duration", precision:1, uiUnits:"ms", dephault:80, "min":0, "max":1000},			
				{id:"randomness", type:"slider", uiName:"Randomness", precision:0, uiUnits:"%", dephault:100, "min":0, "max":500},
				{id:"blinkLayers", type:"layer", uiName:"Blink Layers", dephault: {match: "//Blink"}}
			];
		},

		onCreateBackStageBehavior: function (self) {
			return { order: 1.2, importance : 0.0 };
		},

		onCreateStageBehavior: function (self, args) {
			// NOTE from WL: some options for how I would want to do this with a new API:
			//
			// 1)  - behavior gets some target puppets from Animal
			//     - if targets are not empty, just turn on/off targeted puppets as necessary
			//         = note that this means no "swapping" functionality, or we could by default turn off all other (non-target) siblings
			//     - if targets are empty, apply default matching rule (look for "Blink") to stagePuppet to identify target puppets to blink
			//
			// 2)  - behavior gets some target puppets from Animal
			//     - if targets are not empty, just turn on/off targeted puppets as necessary
			//         = note that this means no "swapping" functionality, or we could by default turn off all other (non-target) siblings
			//     - if targets are empty, do nothing
			//
			// option 1 is close to the functionality that we have right now, but we need target puppets from Animal.
			// option 2 makes the behavior simpler, but requires more manual work from user (identifying blink targets, even if they are named "Blink").
			// we could have option 3 where default matching rule is applied to each target puppet tree, but we lose generality (e.g., non-"Blink" puppets that we want to blink).

			var stagePuppet = args.stagePuppet, 
				allBlinkLayers = args.getStaticParam("blinkLayers");

			self.stagePuppet = stagePuppet;

			// for each blink puppet, get corresponding replacement group (siblings)
			self.blinkPuppetPairs = [];

			allBlinkLayers.forEach(function (lay) {
				var parent = lay.getParentPuppet(), siblings, replGroup = [], puppetPair = [];

				if (parent) {
					siblings = parent.getLayers();
					if (siblings.length > 1) {
						siblings.forEach(function (s) {
							var sdkLayer = s.getSdkLayer();
							if (sdkLayer !== lay) {
								replGroup.push(sdkLayer);
							}
						});
					}

					puppetPair.push(lay);
					puppetPair.push(replGroup);
					self.blinkPuppetPairs.push(puppetPair);
				}
			});

			// initialize blink params
			closed = false;
			duration = 0;
			lastSwitchT = -1;

			ReplacerUtilities.updateReplacerInfo(args);			
		},

		onParamChanged: function (self, id, oldValue, newValue) { // method on behavior (any phase)
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage	
			var dt, replNodes, t = args.t + args.rehearseTime;

			if (lastSwitchT < 0) {
				lastSwitchT = t;
				duration = getDuration(closed, args.getParam("rate"), args.getParam("length"), args.getParam("randomness"));								
			}

			dt = t - lastSwitchT;

			if (dt >= duration) {
				lastSwitchT = t;
				closed = !closed;
				duration = getDuration(closed, args.getParam("rate"), args.getParam("length"), args.getParam("randomness"));				
			}

			replNodes = chooseBlinkReplacements(self, closed);
			ReplacerUtilities.applyReplacements(self, args, kReplacerPriority, kReplacerDoesOverride, replNodes.nodesToShow, replNodes.nodesToHide);
		}

	}; // end of object being returned
});
