﻿#target {BRIDGETALKVERSION}
// Copyright 2010-2014.  Adobe Systems, Incorporated.  All rights reserved.


/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>This script enables other applications to communicate with {PRODUCTNAME}.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec {PRODUCTNAME}.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと {PRODUCTNAME} との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit {PRODUCTNAME} kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con {PRODUCTNAME}</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con {PRODUCTNAME}</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Dit script laat andere toepassingen toe te communiceren met {PRODUCTNAME}</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o {PRODUCTNAME}</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Skriptet gjør at andre programmer kan kommunisere med {PRODUCTNAME}</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Dette script betyder, at andre programmer kan kommunikere med {PRODUCTNAME}</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Tämän komentosarjan avulla muut sovellukset ja {PRODUCTNAME} voivat kommunikoida keskenään</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>Det här skriptet gör det möjligt för andra program att kommunicera med {PRODUCTNAME}</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>"此指令碼能讓其他應用程式與 {PRODUCTNAME} 進行通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>"此脚本使其它应用程序能够与 {PRODUCTNAME} 进行通信</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>{PRODUCTNAME}</dc:title>
     <dc:description>"이 스크립트를 사용하면 다른 응용 프로그램에서 {PRODUCTNAME}과(와) 통신할 수 있습니다.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/



prelude{MAJORVERSION} = {};

prelude{MAJORVERSION}.preludeTargetName = "{BRIDGETALKVERSION}";
prelude{MAJORVERSION}.preludeAppName = "prelude";
prelude{MAJORVERSION}.preludeVersion = "{MAJORVERSION}.{MINORVERSION}";
prelude{MAJORVERSION}.BridgeTargetName = "bridge";

/**
**	open
**
**	Open the passed in files. This may be one or many files.
**
*/
prelude{MAJORVERSION}.open = function(target)
{
	if (BridgeTalk.appSpecifier == prelude{MAJORVERSION}.preludeTargetName)
	{
		var filePaths = [];

		for (var index = 0; index < target.length; index++)
		{
			filePaths[index] = target[index].fsName;
		}

		if (target.length == 1 && app.isDocument(filePaths))
		{
			app.openDocument(filePaths);
		}
		else if (app.isDocumentOpen())
		{
			document.importFiles(filePaths);
		}
	}
	else
	{
		var filesString = prelude{MAJORVERSION}.fileArrayToString(target);
		prelude{MAJORVERSION}.executeScript("prelude{MAJORVERSION}.open(" + filesString + ");");
	}
}

/**
**	executeScript
**
**	Execute the passed in script by sending a bridgetalk message.
*/
prelude{MAJORVERSION}.executeScript = function(script)
{
	if (BridgeTalk.appSpecifier == prelude{MAJORVERSION}.preludeTargetName)
	{
		eval(script);
	}
	else
	{
		// Bring Premiere to the foreground.
		BridgeTalk.bringToFront(prelude{MAJORVERSION}.preludeAppName);

		var btMessage = new BridgeTalk;
		btMessage.target = prelude{MAJORVERSION}.preludeTargetName;
		btMessage.body = script;
		btMessage.send();
	}
}

/**
**	quit
**
**	Performs the equivalent of File>Exit.
*/
prelude{MAJORVERSION}.quit = function()
{
	if (BridgeTalk.appSpecifier == prelude{MAJORVERSION}.preludeTargetName)
	{
		app.quit();
	}
	else
	{
		prelude{MAJORVERSION}.executeScript("app.quit();");
	}
}

/**
**	fileArrayToString
**
**	This routine create a string for the files array that we can transmit
**	over BridgeTalk as text, like this:
**
**	Array (File ('path1'), File ('path2'), File ('path3'))
*/
prelude{MAJORVERSION}.fileArrayToString = function(files)
{
	var filesString = new String("Array (");

	for (var index = 0; index < files.length; index++)
	{
		if (index > 0)
		{
			filesString += ", ";
		}

		filesString += "File ('" + files[index].absoluteURI.toString() + "')";
	}

	// close the Array
	filesString += ")";

	return filesString;
}

/**
**	Open Event
**
**	The event is:
**		event.type - document
**		event.location - document
**		event.object.constructor.name - Document
**		app.document.owner - {BRIDGETALKVERSION}
**
**	The app.document.owner is used to indicate that Bridge is in "slave" mode.
**	Used by applications that use Bridge for their own file browser.
**	Indicated in the window's title as "Opening in {PRODUCTNAME}".
**
**	To get the selection use event.object.selections.
**
*/
prelude{MAJORVERSION}.eventHandler = function(event)
{
	var retval = {};
	retval.handled = false;

	if (event.type == "open"
		&& event.location == "document"
		&& event.object.constructor.name == "Document"
		&& app.document.owner == prelude{MAJORVERSION}.preludeTargetName)
	{
		var sels = event.object.selections;
		var files = [];

		for (var i = 0; i < sels.length; i++)
		{
			files[i] = sels[i].spec;
		}

		if (files.length > 0)
		{
			prelude{MAJORVERSION}.open(files);
			retval.handled = true;
		}
	}

	return retval;
}

if (BridgeTalk.appName == prelude{MAJORVERSION}.BridgeTargetName)
{
	app.eventHandlers.push( {handler:prelude{MAJORVERSION}.eventHandler} );
}
