﻿/* list of events:
    
- getFrontend.onItemAddedToBatch
- getExporter.onEncodeComplete
- getExporter.onMediaInfoCreated
- getExporter.onBatchItemStatusChanged
- getExporter.onItemEncodingStarted
- getExporter.onEncodingItemProgressUpdated
- getExporter.onPostProcessListInitialized
- getEncoderHost.onEncodeProgress
- getEncoderHost.onItemEncodeComplete
- getWatchFolder.onEncodeError
- getWatchFolder.onEncodeComplete

 */

 // map event "getFrontend.onItemAddedToBatch"
app.addEventListener("onItemAddedToBatch", function(eventObj)
{
    if (eventObj.target.onItemAddedToBatch && typeof eventObj.target.onItemAddedToBatch === "function")
    {
        eventObj.target.onItemAddedToBatch();
    }
}, true);

 // map event "getExporter.onEncodeComplete"
app.addEventListener("onEncodeComplete", function(eventObj)
{
    if (eventObj.target.onEncodeComplete && typeof eventObj.target.onEncodeComplete === "function")
    {
        eventObj.target.onEncodeComplete();
    }
}, true);

 // map event "getExporter.onMediaInfoCreated"
app.addEventListener("onMediaInfoCreated", function(eventObj)
{
    if (eventObj.target.onMediaInfoCreated && typeof eventObj.target.onMediaInfoCreated === "function")
    {
        eventObj.target.onMediaInfoCreated();
    }
}, true);

 // map event "getExporter.onBatchItemStatusChanged"
app.addEventListener("onBatchItemStatusChanged", function(eventObj)
{
    if (eventObj.target.onBatchItemStatusChanged && typeof eventObj.target.onBatchItemStatusChanged === "function")
    {
        eventObj.target.onBatchItemStatusChanged();
    }
}, true);

 // map event "getExporter.onItemEncodingStarted"
app.addEventListener("onItemEncodingStarted", function(eventObj)
{
    if (eventObj.target.onItemEncodingStarted && typeof eventObj.target.onItemEncodingStarted === "function")
    {
        eventObj.target.onItemEncodingStarted();
    }
}, true);

 // map event "getExporter.onEncodingItemProgressUpdated"
app.addEventListener("onEncodingItemProgressUpdated", function(eventObj)
{
    if (eventObj.target.onEncodingItemProgressUpdated && typeof eventObj.target.onEncodingItemProgressUpdated === "function")
    {
        eventObj.target.onEncodingItemProgressUpdated();
    }
}, true);

 // map event "getExporter.onPostProcessListInitialized"
app.addEventListener("onPostProcessListInitialized", function(eventObj)
{
    if (eventObj.target.onPostProcessListInitialized && typeof eventObj.target.onPostProcessListInitialized === "function")
    {
        eventObj.target.onPostProcessListInitialized();
    }
}, true);

// map event "getEncoderHost.onEncodeFinished"
app.addEventListener("onEncodeFinished", function(eventObj)
{
    if (eventObj.target.onEncodeFinished && typeof eventObj.target.onEncodeFinished === "function")
    {
        eventObj.target.onEncodeFinished(eventObj.result);
    }
}, true);

// map event "getEncoderHost.onEncodeProgress"
app.addEventListener("onEncodeProgress", function(eventObj)
{
    if (eventObj.target.onEncodeProgress && typeof eventObj.target.onEncodeProgress === "function")
    {
        eventObj.target.onEncodeProgress(eventObj.target.getEncodeProgress()); 
    }
}, true);

// map event "getEncoderHost.onItemEncodeComplete"
app.addEventListener("onItemEncodeComplete", function(eventObj)
{
    if (eventObj.target.onItemEncodeComplete && typeof eventObj.target.onItemEncodeComplete === "function")
    {
        eventObj.target.onItemEncodeComplete();
    }
}, true);

// map event "getWatchFolder.onEncodeError"
app.addEventListener("onEncodeError", function(eventObj)
{
    if (eventObj.target.onEncodeError && typeof eventObj.target.onEncodeError === "function")
    {
        eventObj.target.onEncodeError();
    }
}, true);
