//------------------------------------------------------------------------------------------------------
//--------------------------- Adding all Video Control Event Listeners ---------------------------------
//------------------------------------------------------------------------------------------------------

function videoPlayPauseEventListener(){
    if(window.isVideoPlaying == false) {
        var playPromise = videoPanel.play();
        if (playPromise !== undefined) {
            playPromise.then(_ => {
                window.isVideoPlaying = true;
                videoPlayButton.style.display = "none" ;
                videoPauseButton.style.display = "inline";
        
            }).catch(error => {
                window.isVideoPlaying = false;
            });
        }
    }
    else {
        videoPanel.pause();
        window.isVideoPlaying = false;
        videoPlayButton.style.display = "inline" ;
        videoPauseButton.style.display = "none";
        
    }
}

function attachVideoPlayButtonEventListener(){
    videoPlayButton.addEventListener("click", videoPlayPauseEventListener);
    videoPauseButton.addEventListener("click", videoPlayPauseEventListener);
}

function videoMuteVolEventListener(){
    if (videoPanel.muted == false) {
        videoPanel.muted = true;
        videoMuteButton.style.display = "inline";
        videoVolButton.style.display = "none";
        // updatePlayPauseMuteButtonStyle(videoMuteButton);
    } else {
        videoPanel.muted = false;
        videoMuteButton.style.display = "none";
        videoVolButton.style.display = "inline";
        // updatePlayPauseMuteButtonStyle(videoMuteButton);
    }
}

function attachVideoMuteButtonEvenListener(){
    videoMuteButton.addEventListener("click", videoMuteVolEventListener);
    videoVolButton.addEventListener("click", videoMuteVolEventListener);
}


// Updating video panel current time w.r.t. videoSeekbar.
function attachVideoSeekBarControllerUpdateEventListener(){
    videoSeekBar.addEventListener("change", function (event) {
        var time = videoPanel.duration * (videoSeekBar.value / 100);
        videoPanel.currentTime = time;
    });

    // [TO CHECK LATER] for changing gradient.
    // videoSeekBar.addEventListener("oninput", function (event) {
    //     videoSeekBar.style.background = 'linear-gradient(to right, #FFFFFF 0%, #FFFFFF ' + this.value + '%, #e6e6e6 ' + this.value + '%, #e6e6e6 100%)' ;
    // });
}

// Updating videoSeekbar w.r.t. video panel current time.
function attachVideoTimeUpdateEventListener(){
    videoPanel.addEventListener("timeupdate", function (event) {
        var value = (100 / videoPanel.duration) * videoPanel.currentTime;
        if (isNaN(value)) 
            videoSeekBar.value = 0;
        else 
            videoSeekBar.value = value;
    });
}


function attachVideoEndEventListener(){
    videoPanel.addEventListener("ended", function () {
        videoPlayButton.style.display = "inline";
        videoPauseButton.style.display = "none";
        // updatePlayPauseMuteButtonStyle(videoPlayButton);
        window.isVideoPlaying = false;
    });
}


function attachTempVideoMetadataLoadedListener(){
    tempVideo.addEventListener('loadedmetadata', function(event) {
        var videoURL = decodeURI(tempVideo.src);
        var index = postersToBeGenerated.indexOf(videoURL);
        if (index == -1)
            return;

        function waitUntilTempVideoHasEnoughData() {
            if (tempVideo.readyState === 4) {
                sendPosterImageToID(true, tempVideo, postersAttributes[index]);
                // once poster has been generated, remove it and its attributes from global list.
                postersToBeGenerated.splice(index, 1);
                postersAttributes.splice(index, 1);
               
                if (postersToBeGenerated.length > 0) { 
                    tempVideo.src = postersToBeGenerated[0];
                    tempVideo.load();
                }
            } else {
                // If temp video doesn't have enough data, wait for 100ms.
                setTimeout(waitUntilTempVideoHasEnoughData, 100);
            }
        }
        waitUntilTempVideoHasEnoughData();
    });
}

function handleVideoLoadingError (video){
    var videoSrc = document.getElementById("videoPanelSource").src;
    if(videoSrc != "file://:0/"){
        dispatchEventVideoLoadingError(videoSrc);
        console.log("Video Loading failed", videoSrc);
    }
}
//------------------------------------------------------------------------------------------------------
//--------------------------- Adding all Audio Control Event Listeners ---------------------------------
//------------------------------------------------------------------------------------------------------

function audioPlayPauseEventListener(){
    if (window.isAudioPlaying == false) {
        var playPromise = audioPanel.play();
        if (playPromise !== undefined) {
            playPromise.then(_ => {
                window.isAudioPlaying = true;
                audioPlayButton.style.display = "none";
                audioPauseButton.style.display = "inline";
                // updatePlayPauseMuteButtonStyle(audioPlayButton);
            }) .catch(error => {
                window.isAudioPlaying = false;
                console.error("Playing audio failed.");
            });
        }
    } else {
        audioPanel.pause();
        window.isAudioPlaying = false;
        audioPlayButton.style.display = "inline";
        audioPauseButton.style.display = "none";
        // updatePlayPauseMuteButtonStyle(audioPlayButton);
    }
}

function attachAudioPlayButtonEventListener(){
    audioPlayButton.addEventListener("click", audioPlayPauseEventListener);
    audioPauseButton.addEventListener("click", audioPlayPauseEventListener);
}


function audioMuteVolEventListener() {
    if (audioPanel.muted == false) {
        audioPanel.muted = true;
        audioMuteButton.style.display = "inline";
        audioVolButton.style.display = "none";
        // updatePlayPauseMuteButtonStyle(audioMuteButton);
    } else {
        audioPanel.muted = false;
        audioMuteButton.style.display = "none";
        audioVolButton.style.display = "inline";
        // updatePlayPauseMuteButtonStyle(audioMuteButton);
    }
}

function attachAudioMuteButtonEvenListener(){
    audioMuteButton.addEventListener("click", audioMuteVolEventListener);
    audioVolButton.addEventListener("click", audioMuteVolEventListener);
}



// Updating audio panel current time w.r.t. audioSeekbar.
function attachAudioSeekBarControllerUpdateEventListener(){
    audioSeekBar.addEventListener("change", function () {
        var time = audioPanel.duration * (audioSeekBar.value / 100);
        audioPanel.currentTime = time;
    });
}

// Updating audioSeekbar w.r.t. audio panel current time.
function attachAudioTimeUpdateEventListener(){
    audioPanel.addEventListener("timeupdate", function () {
        var value = (100 / audioPanel.duration) * audioPanel.currentTime;
        if (isNaN(value))
            audioSeekBar.value = 0;
        else 
            audioSeekBar.value = value;
    });
}


function attachAudioEndEventListener(){
    audioPanel.addEventListener("ended", function () {
        audioPlayButton.style.display = "inline";
        audioPauseButton.style.display = "none";
        // updatePlayPauseMuteButtonStyle(videoPlayButton);
        window.isAudioPlaying = false;
    });
}


//-----------------------------------------------------------------------------------------------------
//--------------------------- Adding all CS Interface Event Listeners ---------------------------------
//-----------------------------------------------------------------------------------------------------



// This function is called to disable whole Media Panel.
function disableWholeMediaPanel(event, disablePlaceFromFileButton) {
    console.log("disableWholeMediaPanel");
    // disable the media panel.
    window.isMediaPanelDisabled = true;

    //clear the video source
    window.dataURL = "";
    document.getElementById("videoPanelSource").setAttribute("src", "//:0");
    document.getElementById("videoPanel").load();
    
    // uncheck and disable other options in the video panel.
    var checkBoxArray = [ "videoPlayOnPageLoadCheckbox", "videoLoopCheckBox", "controllerRolloverCheckBox"];
    for(var index = 0; index < checkBoxArray.length; index++){
        var cbox = document.getElementById (checkBoxArray[index]);
        cbox.checked = false;
        cbox.disabled = true;
    }

    // disable poster select dropdown and setting "none" as selected option.
    var dropDownArray = ["videoPosterTypeSelect", "videoControllerSelect"];
    for(var index = 0; index < dropDownArray.length; index++){
        var drpDown = document.getElementById(dropDownArray[index]);
       drpDown.style.color = getOptionColor();
       drpDown.disabled = true;
       drpDown.value = "none";
    }

    // disable buttons
    var buttonsArray = ["videoPdfOptionsButton", "videoPlaceFromUrlButton", "addNavigationPointButton", "removeNavigationPointButton", "videoVolButton", "videoPlayButton", "videoMuteButton", "videoPauseButton", "videoSeekBar"];
    for(var index = 0; index < buttonsArray.length; index++){
       var btn = document.getElementById(buttonsArray[index]);
       btn.disabled = true;
       btn.style.opacity = 0.5;
    }

    const placeFromFileBtn = document.getElementById('videoPlaceFromFileButton');

    if (disablePlaceFromFileButton) {
        placeFromFileBtn.disabled = true;
        placeFromFileBtn.style.opacity = 0.5;
    }
    else {
        placeFromFileBtn.disabled = false;
        placeFromFileBtn.style.opacity = 1.0;
    }
   
    //disable text color of all labels
    var labelsArray = getListOfAllLabels();
    for(var index = 0; index < labelsArray.length; index++){
        var label = labelsArray[index];
        document.getElementById(label).style.color = getDisabledTextColor();
    }

    //update duration-labels
    videoCurrentDurationLabel.innerHTML = "—:—";
    videoTotalDurationLabel.innerHTML = "—:—";

    //navigation points
    document.getElementById("navigationPointsTable").style.display = "none";
    
    
    //hiding refresh button
    videoRefreshButton.style.display = "none";

    // show video panel.
    showVideoPanelContainer();
}


function emptyGraphicFrameUpdateEventListener(event) {
    disableWholeMediaPanel(event, false);
    updateAllFlyoutMenuItems(true, false);

    // enable place video from url button
    var placeVideoFromUrlButton = document.getElementById("videoPlaceFromUrlButton");
    placeVideoFromUrlButton.disabled = false;
    placeVideoFromUrlButton.style.opacity = 1;
}


function mediaPanelNavigationPointTableEventListener(event){
    if (event.data) {
        var eventData = event.data.split(',');
        if(eventData.length > 1){
            var numberOfPoints = parseInt(eventData[1]);
            var navPointList = [];
            for(var i=0; i<numberOfPoints; i++){
                var index = i*3 + 2;
                var nameOfNavPoint = eventData[index];
                var time = parseInt(eventData[index+1]);
                var index = parseInt(eventData[index+2]);
                var navPoint = {name:nameOfNavPoint, time:time, index:index};
                navPointList.push(navPoint);
            }
            updateNavigationPointTable(navPointList);
        }
    }
}

function docWithNoOrMultipleSelectionEventListener(event) {
    disableWholeMediaPanel(event, false);
    updateAllFlyoutMenuItems(false, false);
}

function noDocUpdateEventListener(event) {
    disableWholeMediaPanel(event, true);
    updateAllFlyoutMenuItems(false, false);
}



// This function is called when a video file is placed in the ID 
// and its poster needs to be generated to be displayed in the ID.
function getPosterUpdateEventListener(event){
    if (event.data) {
        var eventData = event.data.split(',');
        var poster = decodeURIComponent (eventData[0]);
        var attributes = {mediaID:parseInt(eventData[1]), documentID:parseInt(eventData[2])};
        postersToBeGenerated.push(poster +  "#t=0.01");
        postersAttributes.push(attributes);
        if(postersToBeGenerated.length > 0) {
            tempVideo.src =  postersToBeGenerated[0];
            tempVideo.load(); 
        }
    }
}

// This function is called when the media poster is chosen 
// from an external file and has been set in ID page item.
function posterFromFileEventListener(event) {    
    var dataRecievedTotal = event.data;
    var res = dataRecievedTotal.split(',');
    var imageLoaded = res[1];
    if ( imageLoaded == "false"){
        var dropdownVideoItem = document.getElementById("videoPosterTypeSelect");
        dropdownVideoItem.value= lastVideoPosterDropDownValue;

        if(lastVideoPosterDropDownValue == "currentFrame"){
            videoRefreshButton.style.display = "block";
        }
        else{
            videoRefreshButton.style.display = "none";
        }
        var dropDownAudioItem = document.getElementById("audioPosterTypeSelect");
        dropDownAudioItem.selectedIndex = lastAudioPosterDropDownValue;
        return;
    }
    addOptionToDropdown(videoPosterDropDown, "fromFile", "video");
    addOptionToDropdown(audioPosterDropDown, "fromFile", "audio"); 
}

// This function is called when the media panel is closed.
function mediaPanelCloseEventListener(event) {
    videoPlayButton.style.display = "inline";
    videoPauseButton.style.display = "none";
    audioPlayButton.style.display = "inline";
    audioPauseButton.style.display = "none";

    videoPanel.pause();
    audioPanel.pause();
    window.isVideoPlaying = false;
    window.isAudioPlaying = false;
    videoPanel.currentTime = 0;
    audioPanel.currentTime = 0;
    document.getElementById("videoPanelSource").setAttribute("src", "//:0");
    document.getElementById("audioPanelSource").setAttribute("src", "//:0");
}

// Dispatches events if menu item is clicked.
function onFlyoutMenuItemClickedEventListener(event) {
    var selectedMenuItem = event.data;
    switch (selectedMenuItem.menuId) {
        case "MENU_0": // Place Video from URL.
            CSXSdispatchEvent("com.adobe.PlaceFromURLMediaPanel", "");
            break;
        case "MENU_1": // PDF Options.
            CSXSdispatchEvent("com.adobe.PDFOptionsMediaPanel", "");
            break;    
    
        default:
            break;
    }
}

// This function is called when app theme is changed.
function onAppThemeColorChangedEventListener(event) {
    var csInterface = new CSInterface();
    let skinInfo = csInterface.getHostEnvironment().appSkinInfo;
    updateThemeWithAppSkinInfo(skinInfo);
}

function resetDefaultsActiveMediaPanel(){
    // Paue video and audio.
    if(window.isVideoPlaying) {
        var videoPanel = document.getElementById("videoPanel");
        videoPanel.pause();
        window.isVideoPlaying = false;
    }
    if (window.isAudioPlaying) {
        var audioPanel = document.getElementById("audioPanel");
        audioPanel.pause();
        window.isAudioPlaying = false;
    }               

    // Update play/pause and mute buttons of audio/video panel.
    videoPlayButton.style.display = "inline";
    videoPauseButton.style.display = "none";                         
    videoMuteButton.style.display = "none";
    videoVolButton.style.display = "inline";

    audioPlayButton.style.display = "inline";
    audioPauseButton.style.display = "none";                         
    audioMuteButton.style.display = "none";
    audioVolButton.style.display = "inline";
}

// This function is called when selection of object in ID changes from one frame to another.
function afterSelectionChangedEventListener(event) {
    resetDefaultsActiveMediaPanel();       
}


// This function is called when video is selectd in ID.
function videoUpdateEventListener(event){
    // Enable the media panel
    window.isMediaPanelDisabled = false;
    
    // checkboxes
    var checkBoxArray = [ "videoPlayOnPageLoadCheckbox", "videoLoopCheckBox", "controllerRolloverCheckBox"];
    for(var index = 0; index < checkBoxArray.length; index++){
        var cbox = document.getElementById (checkBoxArray[index]);
        cbox.disabled = false;
    }

    // enable dropdown
    var dropDownArray = ["videoPosterTypeSelect", "videoControllerSelect"];
    for(var index = 0; index < dropDownArray.length; index++){
        var drpDown = document.getElementById(dropDownArray[index]);
       drpDown.disabled = false;
    }

    // enable buttons
    var buttonsArray = ["videoPdfOptionsButton", "videoPlaceFromUrlButton", "addNavigationPointButton", "removeNavigationPointButton", "videoVolButton", "videoPlayButton", "videoMuteButton", "videoPauseButton", "videoSeekBar"];
    for(var index = 0; index < buttonsArray.length; index++){
       var btn = document.getElementById(buttonsArray[index]);
       btn.disabled = false;
       btn.style.opacity = 1.0;
    }

   
    //enable text color of all labels
    var labelsArray = getListOfAllLabels();
    for(var index = 0; index < labelsArray.length; index++){
        var label = labelsArray[index];
        document.getElementById(label).style.color = getEnabledTextColor();
    }

    //disable total duration label
    document.getElementById( "videoTotalDurationLabel").style.color = getEnabledTextColor();
   

    // Pause audio, if it is playing.
    if(window.isAudioPlaying)
        audioPanel.pause();

    // Update play/pause and mute buttons.  
    videoPlayButton.style.display = window.isVideoPlaying ? "none" : "inline" ;
    videoPauseButton.style.display = window.isVideoPlaying ? "inline" : "none" ;
    videoMuteButton.style.display = videoPanel.muted ? "inline" : "none" ;
    videoVolButton.style.display = videoPanel.muted ? "none" : "inline";

     //navigation points
     document.getElementById("navigationPointsTable").style.display = "inline-table";
     

    // Parse the received event data and update things accordingly.
    var eventData = event.data.split(',');
    var mediaFileName = decodeURIComponent( eventData[0]);
    var isPageLoadEnabled = eventData[1];
    var isLoopEnabled = eventData[2];
    var postertype = eventData[3];
    var isRightToLeftLanguageFS = eventData[4];
    
    if(mediaFileName != currentVideoName){
        resetDefaultsActiveMediaPanel();
    }
    currentVideoName = mediaFileName;
    
    if(isPageLoadEnabled == "true")
        document.getElementById("videoPlayOnPageLoadCheckbox").checked = true;
    else
        document.getElementById("videoPlayOnPageLoadCheckbox").checked = false;
    if(isLoopEnabled == "true")    
        document.getElementById("videoLoopCheckBox").checked =  true ;
    else
        document.getElementById("videoLoopCheckBox").checked =  false;
    
    if(isRightToLeftLanguageFS == "true")
        isLocaleMENA = true;
    else
        isLocaleMENA = false;

   
    // If file's extension belongs to any of the above extension - remove the current frame option.
    if (isUnsupportedExtension(mediaFileName))
        removeOptionFromDropdown(videoPosterDropDown, "currentFrame");
    else {
        addOptionToDropdown(videoPosterDropDown, "currentFrame", "video");
       
    }

    // enable all flyoutMenuItems
    updateAllFlyoutMenuItems(true, true);

    // Load the video.
    if (window.dataURL != mediaFileName) {
        window.dataURL = mediaFileName;
        mediaFileName = mediaFileName + "#t=0.01"; //Taking the first frame in to consideration for src preview.Fixes bug with ID-https://jira.corp.adobe.com/browse/ID-4213582
        document.getElementById("videoPanelSource").setAttribute("src", mediaFileName);
        
        // net::ERR_CACHE_OPERATION_NOT_SUPPORTED was coming. Chrome does not do a good job of caching requests with range-byte headers.
        // To fix it added a parameter with a random seed to every request, which makes it appear to the CEP to be a unique URL.
        if(!videoPanel.readyState){
            var videoSrc = document.getElementById("videoPanelSource").src;
            videoSrc = videoSrc + "?v=" + Math.random();
            document.getElementById("videoPanelSource").src = videoSrc;
        }

        document.getElementById("videoPanel").load();
        showVideoPanelContainer();

        // Keep updating time duration label after every 500ms.
        asyncUpdateDurationLabel(videoPanel, videoCurrentDurationLabel, videoTotalDurationLabel);
    }
    
    // If posterTypeValue is "chooseImage" - add "From File" option to dropdown else remove it.
    var posterTypeValue = getPosterTypeValue(postertype);
    lastVideoPosterDropDownValue = posterTypeValue;
    if (posterTypeValue == "chooseImage") {
        addOptionToDropdown(videoPosterDropDown, "fromFile", "video");       
        videoPosterDropDown.value = "fromFile";
    }
    else {
        removeOptionFromDropdown(videoPosterDropDown, "fromFile");            
        videoPosterDropDown.value = posterTypeValue;
        if (posterTypeValue == "currentFrame") {
            videoRefreshButton.style.display = "block";
        }
    }

    window.videoDropDownSeletedIndex  = videoPosterDropDown.selectedIndex;

    if (window.ignoreNavigationListUpdate === true)
    {   
        window.ignoreNavigationListUpdate = false;
        return;
    }

    dispatchEventUpdateVideoNavigationPoints();

    // Update the style of selected options.
    /*var dropDownArray = ["videoPosterTypeSelect", "videoControllerSelect"];
    for(var index = 0; index < dropDownArray.length; index++){
        var drpDown = document.getElementById(dropDownArray[index]);
        var selectedOption = drpDown.options[drpDown.selectedIndex];
        selectedOption.style.color = getEnabledTextColor();
        selectedOption.backgroundColor = getOptionColor();
        drpDown.style.color = getEnabledTextColor();
    }*/
}

// This function is called when audio is selectd in ID.
function audioUpdateEventListener (event) {
    // Enable the media panel.
    window.isMediaPanelDisabled = false;

    //update Flyout Menu
    updateAllFlyoutMenuItems(false, true);
    //enable text color of all labels
    var labelsArray = getListOfAllLabels();
    for(var index = 0; index < labelsArray.length; index++){
        var label = labelsArray[index];
        document.getElementById(label).style.color = getEnabledTextColor();
    }

    //disable total duration label
    document.getElementById("audioTotalDurationLabel").style.color = getEnabledTextColor();


    // enable interactive pdf option
    var pdfOptionsButton = document.getElementById("audioPdfOptionsButton");
    pdfOptionsButton.disabled = false;
    pdfOptionsButton.style.opacity = 1.0;

    // Pause video if it is playing.
    if(window.isVideoPlaying)
        videoPanel.pause();
       

    // Parse the received event data and update things accordingly.
    var eventData = event.data.split(',');
    var mediaFileName =decodeURIComponent( eventData[0]);
    var isPageLoadEnabled = eventData[1];
    var isLoopEnabled = eventData[2];
    var postertype = eventData[3];
    var isPageTurnCheckboxEnabled = eventData[4];
    var isRightToLeftLanguageFS = eventData[5];

    if(mediaFileName != currentAudioName){
        resetDefaultsActiveMediaPanel();
    }
    currentAudioName = mediaFileName;
    
    if(isLoopEnabled == "true")
        audioLoopCheckBox.checked = true;
    else
        audioLoopCheckBox.checked = false; 
    if(isPageLoadEnabled == "true")     
        audioPlayOnPageLoadCheckbox.checked =  true;
    else    
        audioPlayOnPageLoadCheckbox.checked =  false;
    if(isPageTurnCheckboxEnabled == "true")
        audioStopOnPageTurnCheckbox.checked =  true; 
    else
        audioStopOnPageTurnCheckbox.checked = false;
    
    if(isRightToLeftLanguageFS == "true")
        isLocaleMENA = true;
    else
        isLocaleMENA = false;
   
    // Load the audio.
    if (window.dataURL != mediaFileName) {
        window.dataURL = mediaFileName;
        document.getElementById("audioPanelSource").setAttribute("src", mediaFileName);
        document.getElementById("audioPanel").load();
        showAudioPanelContainer();
        asyncUpdateDurationLabel(audioPanel, audioCurrentDurationLabel, audioTotalDurationLabel);
    }

    var posterTypeValue = getPosterTypeValue(postertype);
    lastAudioPosterDropDownValue = posterTypeValue;
     // If posterTypeValue is "chooseImage" - add "From File" option to dropdown.
    if (posterTypeValue == "chooseImage") { 
        addOptionToDropdown(audioPosterDropDown, "fromFile", "audio"); 
        audioPosterDropDown.value = "fromFile";
    }
    else {
        removeOptionFromDropdown(audioPosterDropDown, "fromFile");
        audioPosterDropDown.value = posterTypeValue;
    }
   
    //var selectedOption = audioPosterDropDown.options[audioPosterDropDown.selectedIndex];
    //selectedOption.style.color = getEnabledTextColor();
    //selectedOption.backgroundColor = getOptionColor();
    //audioPosterDropDown.style.color = getEnabledTextColor();  
}




//-----------------------------------------------------------------------------------------------------
//--------------------------- Adding All Other Element's Event Listeners ---------------------------------
//-----------------------------------------------------------------------------------------------------

function editNavigationPointNameEventListener (event){
    var x = event.target.parentElement;
    $(x).siblings().css('background','none');
    $(x).siblings().css('color','white');
    $(x).siblings().children().css('background','none');
    $(x).siblings().children().css('color',getEnabledTextColor());

    $(event.target).css('background','white');
    $(event.target).css('color','black');
 }
 
 function navigationRowSelectedEventListener(event) {
    selectedNavigationPointRow = this;
    $(this).siblings().css('background','none');
    $(this).siblings().children().css('background','none');
    $(this).siblings().children().css('color',getEnabledTextColor());
    $(this).css('background','rgba(179,212,252,0.7)');
 }

 // This function adds a navigation point to the media panel.
function addNavigationPoint() {
    dispatchEventAddVideoNavigationPoint();
    dispatchEventUpdateVideoNavigationPoints();
}

//This function removes the selected navigatiopn point from media panel.
function removeNavigationPoint() {
    if(selectedNavigationPointRow != null){
        var currRowID = selectedNavigationPointRow.id;
        dispatchEventRemoveVideoNavigationPoint(currRowID);
        dispatchEventUpdateVideoNavigationPoints();
    }
}


//This function removes the selected navigatiopn point from media panel.
function removeNavigationPointAllRows() {
    var navigationPointsTable = document.getElementById("navigationPointsTable");
    var navigationPointsTableChildren = navigationPointsTable.children;

    for(var i=0; i<navigationPointsTableChildren.length; i++){
        navigationPointsTable.removeChild(navigationPointsTableChildren[i]);
    }

    totalRows = 0;
}

function addNavigationPointTableSingleRow(name, time, index){
    totalRows++;
    // document.getElementById("removeNavigationPointButton").disabled = false;
    // document.getElementById("removeNavigationPointButton").opacity = 1.0;

    var navigationPointsTable = document.getElementById("navigationPointsTable");
    var newRow = navigationPointsTable.insertRow();
    newRow.addEventListener("click", navigationRowSelectedEventListener);
    newRow.id = index;

    $(newRow).siblings().css('background','none');
    $(newRow).siblings().children().css('background','none');
    $(newRow).siblings().children().css('color',getEnabledTextColor());
    $(newRow).css('background','rgba(179,212,252,0.7)');

    selectedNavigationPointRow = newRow;
    var cell1 = newRow.insertCell(0);
    var cell2 = newRow.insertCell(1);
    let oldName = name;
	const CHARACTER_LIMIT = 18;

	if (isLocaleMENA) {
        $(cell1).css('direction', 'rtl');
        $(cell1).css('text-align', 'left');
    }

    cell1.innerHTML = name;
    cell1.setAttribute("contenteditable", true);
    cell1.setAttribute("spellcheck", false);
    cell2.innerHTML = getNavigationPointTimefromGivenTime(time);
    
    cell1.addEventListener("dblclick", (event) => {
        const activeCell = event.target;
        oldName = activeCell.textContent;
        editNavigationPointNameEventListener(event);
    });
    
    cell1.addEventListener("keypress", (event) => {
        const ENTER_KEY = 13;
        const TAB_KEY = 9;

        if(event.keyCode == ENTER_KEY) {
            event.preventDefault();
            event.target.blur();
        }
        else if(event.keyCode !== TAB_KEY && event.target.textContent.length === CHARACTER_LIMIT) {
            event.preventDefault();
        }
    });

    cell1.addEventListener("paste", (event) => {
        let clipboardText = event.clipboardData.getData('text');

        if(clipboardText.length === 0) {
            return false;
        }

        const selection = window.getSelection();
        selection.deleteFromDocument();
        
        if(selection.rangeCount > 0) {
            const rangeObj = selection.getRangeAt(0);
            let currName = cell1.textContent;
            let newName = currName.substring(0, rangeObj.endOffset) + clipboardText + currName.substr(rangeObj.endOffset);
            newName = newName.substr(0, CHARACTER_LIMIT);
            cell1.textContent = newName;
            const newRange = document.createRange();
            newRange.setStart(cell1.childNodes[0], newName.length);
            newRange.collapse(true);
            selection.removeAllRanges();
            selection.addRange(newRange);
        }

        event.preventDefault();
    });

    cell1.addEventListener("blur", (event) => {
        const activeCell = event.target;
        const newName = activeCell.textContent;
		
		$(activeCell).css('background','none');
        $(activeCell).css('color', getEnabledTextColor());
        
        if(newName.length > 0 && newName !== oldName) {
            dispatchEventChangeNameofNavigationPoint(newName, index);
            window.ignoreNavigationListUpdate = true;
        }
        else {
            activeCell.textContent = oldName;
        }
    });

    // table div
    var tableDiv = document.getElementById("navigationPointsDiv");
    tableDiv.scrollTop = tableDiv.scrollHeight;
}

function updateNavigationPointTable(navPointList){
    removeNavigationPointAllRows();
    for(point of navPointList){
        addNavigationPointTableSingleRow(point.name, point.time, point.index);
    }
}

function attachToolTipEventListeners() {
    const toolTipNodes = document.querySelectorAll("[tooltip-data]");
    
    const shouldShowToolTip = (node) => {
        let showTip = true;

        if(node.hasAttribute('tooltip-locale-specific')) {
            if(node.scrollWidth <= node.offsetWidth) {
                showTip = false;
            }
        }

        return showTip;
    }

    toolTipNodes.forEach((node, idx) => {
        node.addEventListener("mouseover", (event) => {
            if(shouldShowToolTip(node)) {
                const toolTipId = node.getAttribute('tooltip-data');
                showToolTip(node, toolTipId); 
            }
        });

        node.addEventListener("mouseout", (event) => {
            if(shouldShowToolTip(node)) {
                hideToolTip();
            }
        });
        
    });   
}