/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.AttributeHTML;
import org.apache.bcel.util.CodeHTML;
import org.apache.bcel.util.ConstantHTML;
import org.apache.bcel.util.MethodHTML;

public class Class2HTML
implements Constants {
    private JavaClass java_class;
    private String dir;
    private static String class_package;
    private static String class_name;
    private static ConstantPool constant_pool;

    public Class2HTML(JavaClass java_class, String dir) throws IOException {
        Method[] methods = java_class.getMethods();
        this.java_class = java_class;
        this.dir = dir;
        class_name = java_class.getClassName();
        constant_pool = java_class.getConstantPool();
        int index = class_name.lastIndexOf(46);
        class_package = index > -1 ? class_name.substring(0, index) : "";
        ConstantHTML constant_html = new ConstantHTML(dir, class_name, class_package, methods, constant_pool);
        AttributeHTML attribute_html = new AttributeHTML(dir, class_name, constant_pool, constant_html);
        MethodHTML method_html = new MethodHTML(dir, class_name, methods, java_class.getFields(), constant_html, attribute_html);
        this.writeMainHTML(attribute_html);
        new CodeHTML(dir, class_name, methods, constant_pool, constant_html);
        attribute_html.close();
    }

    public static void main(String[] argv) {
        String[] file_name = new String[argv.length];
        int files = 0;
        ClassParser parser = null;
        JavaClass java_class = null;
        String zip_file = null;
        char sep = System.getProperty("file.separator").toCharArray()[0];
        String dir = "." + sep;
        try {
            int i2;
            for (i2 = 0; i2 < argv.length; ++i2) {
                if (argv[i2].charAt(0) == '-') {
                    if (argv[i2].equals("-d")) {
                        if (!(dir = argv[++i2]).endsWith("" + sep)) {
                            dir = dir + sep;
                        }
                        new File(dir).mkdirs();
                        continue;
                    }
                    if (argv[i2].equals("-zip")) {
                        zip_file = argv[++i2];
                        continue;
                    }
                    System.out.println("Unknown option " + argv[i2]);
                    continue;
                }
                file_name[files++] = argv[i2];
            }
            if (files == 0) {
                System.err.println("Class2HTML: No input files specified.");
            } else {
                for (i2 = 0; i2 < files; ++i2) {
                    System.out.print("Processing " + file_name[i2] + "...");
                    parser = zip_file == null ? new ClassParser(file_name[i2]) : new ClassParser(zip_file, file_name[i2]);
                    java_class = parser.parse();
                    new Class2HTML(java_class, dir);
                    System.out.println("Done.");
                }
            }
        }
        catch (Exception e2) {
            System.out.println(e2);
            e2.printStackTrace(System.out);
        }
    }

    static String referenceClass(int index) {
        String str = constant_pool.getConstantString(index, (byte)7);
        str = Utility.compactClassName(str);
        str = Utility.compactClassName(str, class_package + ".", true);
        return "<A HREF=\"" + class_name + "_cp.html#cp" + index + "\" TARGET=ConstantPool>" + str + "</A>";
    }

    static final String referenceType(String type) {
        String short_type = Utility.compactClassName(type);
        short_type = Utility.compactClassName(short_type, class_package + ".", true);
        int index = type.indexOf(91);
        String base_type = type;
        if (index > -1) {
            base_type = type.substring(0, index);
        }
        if (base_type.equals("int") || base_type.equals("short") || base_type.equals("boolean") || base_type.equals("void") || base_type.equals("char") || base_type.equals("byte") || base_type.equals("long") || base_type.equals("double") || base_type.equals("float")) {
            return "<FONT COLOR=\"#00FF00\">" + type + "</FONT>";
        }
        return "<A HREF=\"" + base_type + ".html\" TARGET=_top>" + short_type + "</A>";
    }

    static String toHTML(String str) {
        StringBuffer buf = new StringBuffer();
        try {
            block8: for (int i2 = 0; i2 < str.length(); ++i2) {
                char ch = str.charAt(i2);
                switch (ch) {
                    case '<': {
                        buf.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        buf.append("&gt;");
                        continue block8;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block8;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return buf.toString();
    }

    private void writeMainHTML(AttributeHTML attribute_html) throws IOException {
        PrintWriter file = new PrintWriter(new FileOutputStream(this.dir + class_name + ".html"));
        Attribute[] attributes = this.java_class.getAttributes();
        file.println("<HTML>\n<HEAD><TITLE>Documentation for " + class_name + "</TITLE>" + "</HEAD>\n" + "<FRAMESET BORDER=1 cols=\"30%,*\">\n" + "<FRAMESET BORDER=1 rows=\"80%,*\">\n" + "<FRAME NAME=\"ConstantPool\" SRC=\"" + class_name + "_cp.html" + "\"\n MARGINWIDTH=\"0\" " + "MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n" + "<FRAME NAME=\"Attributes\" SRC=\"" + class_name + "_attributes.html" + "\"\n MARGINWIDTH=\"0\" " + "MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n" + "</FRAMESET>\n" + "<FRAMESET BORDER=1 rows=\"80%,*\">\n" + "<FRAME NAME=\"Code\" SRC=\"" + class_name + "_code.html\"\n MARGINWIDTH=0 " + "MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n" + "<FRAME NAME=\"Methods\" SRC=\"" + class_name + "_methods.html\"\n MARGINWIDTH=0 " + "MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n" + "</FRAMESET></FRAMESET></HTML>");
        file.close();
        for (int i2 = 0; i2 < attributes.length; ++i2) {
            attribute_html.writeAttribute(attributes[i2], "class" + i2);
        }
    }
}

