/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodObserver;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.util.BCELComparator;

public class MethodGen
extends FieldGenOrMethodGen {
    private String class_name;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private boolean strip_attributes;
    private List variable_vec = new ArrayList();
    private List line_number_vec = new ArrayList();
    private List exception_vec = new ArrayList();
    private List throws_vec = new ArrayList();
    private List code_attrs_vec = new ArrayList();
    private static BCELComparator _cmp = new BCELComparator(){

        public boolean equals(Object o1, Object o2) {
            MethodGen THIS = (MethodGen)o1;
            MethodGen THAT = (MethodGen)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        public int hashCode(Object o2) {
            MethodGen THIS = (MethodGen)o2;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private List observers;

    public MethodGen(int access_flags, Type return_type, Type[] arg_types, String[] arg_names, String method_name, String class_name, InstructionList il, ConstantPoolGen cp) {
        this.setAccessFlags(access_flags);
        this.setType(return_type);
        this.setArgumentTypes(arg_types);
        this.setArgumentNames(arg_names);
        this.setName(method_name);
        this.setClassName(class_name);
        this.setInstructionList(il);
        this.setConstantPool(cp);
        boolean abstract_ = this.isAbstract() || this.isNative();
        InstructionHandle start = null;
        InstructionHandle end = null;
        if (!abstract_) {
            start = il.getStart();
            end = il.getEnd();
            if (!this.isStatic() && class_name != null) {
                this.addLocalVariable("this", new ObjectType(class_name), start, end);
            }
        }
        if (arg_types != null) {
            int i2;
            int size = arg_types.length;
            for (i2 = 0; i2 < size; ++i2) {
                if (Type.VOID != arg_types[i2]) continue;
                throw new ClassGenException("'void' is an illegal argument type for a method");
            }
            if (arg_names != null) {
                if (size != arg_names.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + arg_names.length);
                }
            } else {
                arg_names = new String[size];
                for (i2 = 0; i2 < size; ++i2) {
                    arg_names[i2] = "arg" + i2;
                }
                this.setArgumentNames(arg_names);
            }
            if (!abstract_) {
                for (i2 = 0; i2 < size; ++i2) {
                    this.addLocalVariable(arg_names[i2], arg_types[i2], start, end);
                }
            }
        }
    }

    public MethodGen(Method m2, String class_name, ConstantPoolGen cp) {
        this(m2.getAccessFlags(), Type.getReturnType(m2.getSignature()), Type.getArgumentTypes(m2.getSignature()), null, m2.getName(), class_name, (m2.getAccessFlags() & 0x500) == 0 ? new InstructionList(m2.getCode().getCode()) : null, cp);
        Attribute[] attributes = m2.getAttributes();
        for (int i2 = 0; i2 < attributes.length; ++i2) {
            Attribute a = attributes[i2];
            if (a instanceof Code) {
                InstructionHandle end;
                Code c2 = (Code)a;
                this.setMaxStack(c2.getMaxStack());
                this.setMaxLocals(c2.getMaxLocals());
                CodeException[] ces = c2.getExceptionTable();
                if (ces != null) {
                    for (int j2 = 0; j2 < ces.length; ++j2) {
                        CodeException ce = ces[j2];
                        int type = ce.getCatchType();
                        ObjectType c_type = null;
                        if (type > 0) {
                            String cen = m2.getConstantPool().getConstantString(type, (byte)7);
                            c_type = new ObjectType(cen);
                        }
                        int end_pc = ce.getEndPC();
                        int length = m2.getCode().getCode().length;
                        if (length == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(ce.getStartPC()), end, this.il.findHandle(ce.getHandlerPC()), c_type);
                    }
                }
                Attribute[] c_attributes = c2.getAttributes();
                for (int j3 = 0; j3 < c_attributes.length; ++j3) {
                    Node l2;
                    int k2;
                    a = c_attributes[j3];
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln = ((LineNumberTable)a).getLineNumberTable();
                        for (k2 = 0; k2 < ln.length; ++k2) {
                            l2 = ln[k2];
                            InstructionHandle ih = this.il.findHandle(((LineNumber)l2).getStartPC());
                            if (ih == null) continue;
                            this.addLineNumber(ih, ((LineNumber)l2).getLineNumber());
                        }
                        continue;
                    }
                    if (a instanceof LocalVariableTable) {
                        LocalVariable[] lv = ((LocalVariableTable)a).getLocalVariableTable();
                        this.removeLocalVariables();
                        for (k2 = 0; k2 < lv.length; ++k2) {
                            l2 = lv[k2];
                            InstructionHandle start = this.il.findHandle(((LocalVariable)l2).getStartPC());
                            end = this.il.findHandle(((LocalVariable)l2).getStartPC() + ((LocalVariable)l2).getLength());
                            if (null == start) {
                                start = this.il.getStart();
                            }
                            if (null == end) {
                                end = this.il.getEnd();
                            }
                            this.addLocalVariable(((LocalVariable)l2).getName(), Type.getType(((LocalVariable)l2).getSignature()), ((LocalVariable)l2).getIndex(), start, end);
                        }
                        continue;
                    }
                    this.addCodeAttribute(a);
                }
                continue;
            }
            if (a instanceof ExceptionTable) {
                String[] names = ((ExceptionTable)a).getExceptionNames();
                for (int j4 = 0; j4 < names.length; ++j4) {
                    this.addException(names[j4]);
                }
                continue;
            }
            this.addAttribute(a);
        }
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end) {
        byte t2 = type.getType();
        if (t2 != 16) {
            LocalVariableGen l2;
            int i2;
            int add = type.getSize();
            if (slot + add > this.max_locals) {
                this.max_locals = slot + add;
            }
            if ((i2 = this.variable_vec.indexOf(l2 = new LocalVariableGen(slot, name, type, start, end))) >= 0) {
                this.variable_vec.set(i2, l2);
            } else {
                this.variable_vec.add(l2);
            }
            return l2;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String name, Type type, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, this.max_locals, start, end);
    }

    public void removeLocalVariable(LocalVariableGen l2) {
        this.variable_vec.remove(l2);
    }

    public void removeLocalVariables() {
        this.variable_vec.clear();
    }

    private static final void sort(LocalVariableGen[] vars, int l2, int r2) {
        int i2 = l2;
        int j2 = r2;
        int m2 = vars[(l2 + r2) / 2].getIndex();
        while (true) {
            if (vars[i2].getIndex() < m2) {
                ++i2;
                continue;
            }
            while (m2 < vars[j2].getIndex()) {
                --j2;
            }
            if (i2 <= j2) {
                LocalVariableGen h2 = vars[i2];
                vars[i2] = vars[j2];
                vars[j2] = h2;
                ++i2;
                --j2;
            }
            if (i2 > j2) break;
        }
        if (l2 < j2) {
            MethodGen.sort(vars, l2, j2);
        }
        if (i2 < r2) {
            MethodGen.sort(vars, i2, r2);
        }
    }

    public LocalVariableGen[] getLocalVariables() {
        int size = this.variable_vec.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.variable_vec.toArray(lg);
        for (int i2 = 0; i2 < size; ++i2) {
            if (lg[i2].getStart() == null) {
                lg[i2].setStart(this.il.getStart());
            }
            if (lg[i2].getEnd() != null) continue;
            lg[i2].setEnd(this.il.getEnd());
        }
        if (size > 1) {
            MethodGen.sort(lg, 0, size - 1);
        }
        return lg;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        for (int i2 = 0; i2 < size; ++i2) {
            lv[i2] = lg[i2].getLocalVariable(cp);
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int src_line) {
        LineNumberGen l2 = new LineNumberGen(ih, src_line);
        this.line_number_vec.add(l2);
        return l2;
    }

    public void removeLineNumber(LineNumberGen l2) {
        this.line_number_vec.remove(l2);
    }

    public void removeLineNumbers() {
        this.line_number_vec.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.toArray(lg);
        return lg;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen cp) {
        int size = this.line_number_vec.size();
        LineNumber[] ln = new LineNumber[size];
        try {
            for (int i2 = 0; i2 < size; ++i2) {
                ln[i2] = ((LineNumberGen)this.line_number_vec.get(i2)).getLineNumber();
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            // empty catch block
        }
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c2 = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exception_vec.add(c2);
        return c2;
    }

    public void removeExceptionHandler(CodeExceptionGen c2) {
        this.exception_vec.remove(c2);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.toArray(cg);
        return cg;
    }

    private CodeException[] getCodeExceptions() {
        int size = this.exception_vec.size();
        CodeException[] c_exc = new CodeException[size];
        try {
            for (int i2 = 0; i2 < size; ++i2) {
                CodeExceptionGen c2 = (CodeExceptionGen)this.exception_vec.get(i2);
                c_exc[i2] = c2.getCodeException(this.cp);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return c_exc;
    }

    public void addException(String class_name) {
        this.throws_vec.add(class_name);
    }

    public void removeException(String c2) {
        this.throws_vec.remove(c2);
    }

    public void removeExceptions() {
        this.throws_vec.clear();
    }

    public String[] getExceptions() {
        String[] e2 = new String[this.throws_vec.size()];
        this.throws_vec.toArray(e2);
        return e2;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen cp) {
        int size = this.throws_vec.size();
        int[] ex = new int[size];
        try {
            for (int i2 = 0; i2 < size; ++i2) {
                ex[i2] = cp.addClass((String)this.throws_vec.get(i2));
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            // empty catch block
        }
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public void addCodeAttribute(Attribute a) {
        this.code_attrs_vec.add(a);
    }

    public void removeCodeAttribute(Attribute a) {
        this.code_attrs_vec.remove(a);
    }

    public void removeCodeAttributes() {
        this.code_attrs_vec.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributes = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.toArray(attributes);
        return attributes;
    }

    public Method getMethod() {
        String signature = this.getSignature();
        int name_index = this.cp.addUtf8(this.name);
        int signature_index = this.cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            lvt = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(lvt);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            lnt = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        for (int i2 = 0; i2 < code_attrs.length; ++i2) {
            attrs_len += code_attrs[i2].getLength() + 6;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract() && !this.isNative()) {
            Attribute[] attributes = this.getAttributes();
            for (int i3 = 0; i3 < attributes.length; ++i3) {
                Attribute a = attributes[i3];
                if (!(a instanceof Code)) continue;
                this.removeAttribute(a);
            }
            code = new Code(this.cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.max_stack, this.max_locals, byte_code, c_exc, code_attrs, this.cp.getConstantPool());
            this.addAttribute(code);
        }
        ExceptionTable et = null;
        if (this.throws_vec.size() > 0) {
            et = this.getExceptionTable(this.cp);
            this.addAttribute(et);
        }
        Method m2 = new Method(this.access_flags, name_index, signature_index, this.getAttributes(), this.cp.getConstantPool());
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        return m2;
    }

    public void removeNOPs() {
        if (this.il != null) {
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                InstructionHandle next = ih.next;
                if (next != null && ih.getInstruction() instanceof NOP) {
                    try {
                        this.il.delete(ih);
                    }
                    catch (TargetLostException e2) {
                        InstructionHandle[] targets = e2.getTargets();
                        for (int i2 = 0; i2 < targets.length; ++i2) {
                            InstructionTargeter[] targeters = targets[i2].getTargeters();
                            for (int j2 = 0; j2 < targeters.length; ++j2) {
                                targeters[j2].updateTarget(targets[i2], next);
                            }
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setMaxLocals(int m2) {
        this.max_locals = m2;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int m2) {
        this.max_stack = m2;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String class_name) {
        this.class_name = class_name;
    }

    public void setReturnType(Type return_type) {
        this.setType(return_type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] arg_types) {
        this.arg_types = arg_types;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(int i2, Type type) {
        this.arg_types[i2] = type;
    }

    public Type getArgumentType(int i2) {
        return this.arg_types[i2];
    }

    public void setArgumentNames(String[] arg_names) {
        this.arg_names = arg_names;
    }

    public String[] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(int i2, String name) {
        this.arg_names[i2] = name;
    }

    public String getArgumentName(int i2) {
        return this.arg_names[i2];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList il) {
        this.il = il;
    }

    public String getSignature() {
        return Type.getMethodSignature(this.type, this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max;
            int n2 = max = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                for (int i2 = 0; i2 < this.arg_types.length; ++i2) {
                    max += this.arg_types[i2].getSize();
                }
            }
            for (InstructionHandle ih = this.il.getStart(); ih != null; ih = ih.getNext()) {
                int index;
                Instruction ins = ih.getInstruction();
                if (!(ins instanceof LocalVariableInstruction) && !(ins instanceof RET) && !(ins instanceof IINC) || (index = ((IndexedInstruction)((Object)ins)).getIndex() + ((TypedInstruction)((Object)ins)).getType(this.cp).getSize()) <= max) continue;
                max = index;
            }
            this.max_locals = max;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripAttributes(boolean flag) {
        this.strip_attributes = flag;
    }

    public static int getMaxStack(ConstantPoolGen cp, InstructionList il, CodeExceptionGen[] et) {
        BranchStack branchTargets = new BranchStack();
        for (int i2 = 0; i2 < et.length; ++i2) {
            InstructionHandle handler_pc = et[i2].getHandlerPC();
            if (handler_pc == null) continue;
            branchTargets.push(handler_pc, 1);
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt2;
            Instruction instruction = ih.getInstruction();
            short opcode = instruction.getOpcode();
            int delta = instruction.produceStack(cp) - instruction.consumeStack(cp);
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    Select select = (Select)branch;
                    InstructionHandle[] targets = select.getTargets();
                    for (int i3 = 0; i3 < targets.length; ++i3) {
                        branchTargets.push(targets[i3], stackDepth);
                    }
                    ih = null;
                } else if (!(branch instanceof IfInstruction)) {
                    if (opcode == 168 || opcode == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt2 = branchTargets.pop()) == null) continue;
            ih = bt2.target;
            stackDepth = bt2.stackDepth;
        }
        return maxStackDepth;
    }

    public void addObserver(MethodObserver o2) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(o2);
    }

    public void removeObserver(MethodObserver o2) {
        if (this.observers != null) {
            this.observers.remove(o2);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator e2 = this.observers.iterator();
            while (e2.hasNext()) {
                ((MethodObserver)e2.next()).notify(this);
            }
        }
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        String signature = Type.getMethodSignature(this.type, this.arg_types);
        signature = Utility.methodSignatureToString(signature, this.name, access, true, this.getLocalVariableTable(this.cp));
        StringBuffer buf = new StringBuffer(signature);
        if (this.throws_vec.size() > 0) {
            Iterator e2 = this.throws_vec.iterator();
            while (e2.hasNext()) {
                buf.append("\n\t\tthrows ").append(e2.next());
            }
        }
        return buf.toString();
    }

    public MethodGen copy(String class_name, ConstantPoolGen cp) {
        Method m2 = ((MethodGen)this.clone()).getMethod();
        MethodGen mg = new MethodGen(m2, class_name, this.cp);
        if (this.cp != cp) {
            mg.setConstantPool(cp);
            mg.getInstructionList().replaceConstantPool(this.cp, cp);
        }
        return mg;
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator comparator) {
        _cmp = comparator;
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }

    static final class BranchStack {
        Stack branchTargets = new Stack();
        Hashtable visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(InstructionHandle target, int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt2 = (BranchTarget)this.branchTargets.pop();
                return bt2;
            }
            return null;
        }

        private final BranchTarget visit(InstructionHandle target, int stackDepth) {
            BranchTarget bt2 = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt2);
            return bt2;
        }

        private final boolean visited(InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle target, int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }
}

