/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

public final class BranchHandle
extends InstructionHandle {
    private BranchInstruction bi;
    private static BranchHandle bh_list = null;

    private BranchHandle(BranchInstruction i2) {
        super(i2);
        this.bi = i2;
    }

    static final BranchHandle getBranchHandle(BranchInstruction i2) {
        if (bh_list == null) {
            return new BranchHandle(i2);
        }
        BranchHandle bh2 = bh_list;
        bh_list = (BranchHandle)bh2.next;
        bh2.setInstruction(i2);
        return bh2;
    }

    protected void addHandle() {
        this.next = bh_list;
        bh_list = this;
    }

    public int getPosition() {
        return this.bi.position;
    }

    void setPosition(int pos) {
        this.i_position = this.bi.position = pos;
    }

    protected int updatePosition(int offset, int max_offset) {
        int x2 = this.bi.updatePosition(offset, max_offset);
        this.i_position = this.bi.position;
        return x2;
    }

    public void setTarget(InstructionHandle ih) {
        this.bi.setTarget(ih);
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        this.bi.updateTarget(old_ih, new_ih);
    }

    public InstructionHandle getTarget() {
        return this.bi.getTarget();
    }

    public void setInstruction(Instruction i2) {
        super.setInstruction(i2);
        if (!(i2 instanceof BranchInstruction)) {
            throw new ClassGenException("Assigning " + i2 + " to branch handle which is not a branch instruction");
        }
        this.bi = (BranchInstruction)i2;
    }
}

