/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;

public final class Method
extends FieldOrMethod {
    private static BCELComparator _cmp = new BCELComparator(){

        public boolean equals(Object o1, Object o2) {
            Method THIS = (Method)o1;
            Method THAT = (Method)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        public int hashCode(Object o2) {
            Method THIS = (Method)o2;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };

    public Method() {
    }

    public Method(Method c2) {
        super(c2);
    }

    Method(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        super(file, constant_pool);
    }

    public Method(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    public void accept(Visitor v2) {
        v2.visitMethod(this);
    }

    public final Code getCode() {
        for (int i2 = 0; i2 < this.attributes_count; ++i2) {
            if (!(this.attributes[i2] instanceof Code)) continue;
            return (Code)this.attributes[i2];
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        for (int i2 = 0; i2 < this.attributes_count; ++i2) {
            if (!(this.attributes[i2] instanceof ExceptionTable)) continue;
            return (ExceptionTable)this.attributes[i2];
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLocalVariableTable();
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLineNumberTable();
    }

    public final String toString() {
        String str;
        String access = Utility.accessToString(this.access_flags);
        ConstantUtf8 c2 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String signature = c2.getBytes();
        c2 = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String name = c2.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access, true, this.getLocalVariableTable());
        StringBuffer buf = new StringBuffer(signature);
        for (int i2 = 0; i2 < this.attributes_count; ++i2) {
            Attribute a = this.attributes[i2];
            if (a instanceof Code || a instanceof ExceptionTable) continue;
            buf.append(" [").append(a.toString()).append("]");
        }
        ExceptionTable e2 = this.getExceptionTable();
        if (e2 != null && !(str = e2.toString()).equals("")) {
            buf.append("\n\t\tthrows ").append(str);
        }
        return buf.toString();
    }

    public final Method copy(ConstantPool _constant_pool) {
        return (Method)this.copy_(_constant_pool);
    }

    public Type getReturnType() {
        return Type.getReturnType(this.getSignature());
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getSignature());
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator comparator) {
        _cmp = comparator;
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

