/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;

public final class Field
extends FieldOrMethod {
    private static BCELComparator _cmp = new BCELComparator(){

        public boolean equals(Object o1, Object o2) {
            Field THIS = (Field)o1;
            Field THAT = (Field)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        public int hashCode(Object o2) {
            Field THIS = (Field)o2;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };

    public Field(Field c2) {
        super(c2);
    }

    Field(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        super(file, constant_pool);
    }

    public Field(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    public void accept(Visitor v2) {
        v2.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        for (int i2 = 0; i2 < this.attributes_count; ++i2) {
            if (this.attributes[i2].getTag() != 1) continue;
            return (ConstantValue)this.attributes[i2];
        }
        return null;
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        access = access.equals("") ? "" : access + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuffer buf = new StringBuffer(64);
        buf.append(access).append(signature).append(" ").append(name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = ").append(cv);
        }
        for (int i2 = 0; i2 < this.attributes_count; ++i2) {
            Attribute a = this.attributes[i2];
            if (a instanceof ConstantValue) continue;
            buf.append(" [").append(a.toString()).append("]");
        }
        return buf.toString();
    }

    public final Field copy(ConstantPool _constant_pool) {
        return (Field)this.copy_(_constant_pool);
    }

    public Type getType() {
        return Type.getReturnType(this.getSignature());
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator comparator) {
        _cmp = comparator;
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

