/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.SequentialType;
import llvm.Type;
import llvm.llvmJNI;

public class ArrayType
extends SequentialType {
    private long swigCPtr;

    protected ArrayType(long l2, boolean bl2) {
        super(llvmJNI.SWIGArrayTypeUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(ArrayType arrayType) {
        return arrayType == null ? 0L : arrayType.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_ArrayType(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static ArrayType get(Type type, BigInteger bigInteger) {
        long l2 = llvmJNI.ArrayType_get(Type.getCPtr(type), type, bigInteger);
        return l2 == 0L ? null : new ArrayType(l2, false);
    }

    public static boolean isValidElementType(Type type) {
        return llvmJNI.ArrayType_isValidElementType(Type.getCPtr(type), type);
    }

    public BigInteger getNumElements() {
        return llvmJNI.ArrayType_getNumElements(this.swigCPtr, this);
    }

    public static boolean classof(ArrayType arrayType) {
        return llvmJNI.ArrayType_classof__SWIG_0(ArrayType.getCPtr(arrayType), arrayType);
    }

    public static boolean classof(Type type) {
        return llvmJNI.ArrayType_classof__SWIG_1(Type.getCPtr(type), type);
    }

    public static ArrayType dyn_cast(SequentialType sequentialType) {
        long l2 = llvmJNI.ArrayType_dyn_cast(SequentialType.getCPtr(sequentialType), sequentialType);
        return l2 == 0L ? null : new ArrayType(l2, false);
    }
}

